--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with CONDITION_HANDLING, SYSTEM;
use  CONDITION_HANDLING, SYSTEM;

function LOGICAL_TO_STRING(
    S	    : STRING;
    DEFAULT : STRING)
    return STRING is

    STATUS  : COND_VALUE_TYPE;
    LENGTH  : UNSIGNED_WORD;
    BUFFER  : STRING(1..128);
    LAST    : INTEGER := 0;

    procedure TRNLOG (
	STATUS			: out COND_VALUE_TYPE;				-- return value
	LOGICAL_NAME		: in  STRING;
	WORD_INTEGER_DEST_LENGTH: out UNSIGNED_WORD;
	DESTINATION_STRING	: out STRING;
	BYTE_INTEGER_TABLE	: in  ADDRESS		:= ADDRESS_ZERO;	-- To omit optional BYTE_INTEGER_TABLE argument
	ACCESS_MODE		: in  ADDRESS		:= ADDRESS_ZERO;	-- To omit optional ACCESS_MODE argument
	BYTE_INTEGER_DISABLE_MASK : in  UNSIGNED_BYTE	:= UNSIGNED_BYTE'NULL_PARAMETER);

    pragma INTERFACE(LIB, TRNLOG);

    pragma IMPORT_VALUED_PROCEDURE (TRNLOG, "LIB$SYS_TRNLOG",
	(COND_VALUE_TYPE, STRING, UNSIGNED_WORD, STRING, ADDRESS, ADDRESS, UNSIGNED_BYTE),
	(VALUE, DESCRIPTOR(S), REFERENCE, DESCRIPTOR(S), VALUE, VALUE, REFERENCE),
	 BYTE_INTEGER_TABLE);
 
begin

    begin
	TRNLOG(STATUS, S, LENGTH, BUFFER);

	if (CONDITION_HANDLING.MATCH_COND(STATUS, 1) /= 0)
	and SYSTEM."/="(LENGTH, 0)
	then
	    return BUFFER(1..INTEGER(LENGTH));
	end if;

    exception
	when others => null;
    end;

    return DEFAULT;

end;
