--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with CALENDAR;
pragma ELABORATE(CALENDAR);

package body SYSTEM_INTERFACE is

    function DIGITS_SQRT(A : SOME_FLOAT) return SOME_FLOAT is

	function BUILTIN_SQRT (A : SOME_FLOAT) return SOME_FLOAT;
	pragma INTERFACE (BUILTIN, BUILTIN_SQRT);
	pragma IMPORT_FUNCTION (BUILTIN_SQRT, "SQRT", MECHANISM => VALUE);

    begin
	return BUILTIN_SQRT(A);
    end;

    function GET_CPU_TIME return DURATION is
    begin
	return 0.01;
    end;

    function RANDOM return FLOAT is
	function RTL_RANDOM return INTEGER;
	    pragma INTERFACE(C, RTL_RANDOM);
	    pragma IMPORT_FUNCTION(RTL_RANDOM, external=>"random");
    begin
	return FLOAT(RTL_RANDOM)/FLOAT(INTEGER'last);
    end;

    function SIN(X : FAST_FLOAT) return FAST_FLOAT is
	function BUILTIN_SIN (A : FAST_FLOAT) return FAST_FLOAT;
	pragma INTERFACE (BUILTIN, BUILTIN_SIN);
	pragma IMPORT_FUNCTION (BUILTIN_SIN, "SIN", MECHANISM => VALUE);

    begin
	return BUILTIN_SIN(X);
    end;

    function ASIN(X : FAST_FLOAT) return FAST_FLOAT is
	function BUILTIN_ASIN (A : FAST_FLOAT) return FAST_FLOAT;
	pragma INTERFACE (BUILTIN, BUILTIN_ASIN);
	pragma IMPORT_FUNCTION (BUILTIN_ASIN, "ASIN", MECHANISM => VALUE);

    begin
	return BUILTIN_ASIN(X);
    end;

    function ALLOCATE_MEMORY(NUMBER_OF_BYTES : POSITIVE) return ADDRESS is
	function MALLOC(NUMBER_OF_BYTES : POSITIVE) return ADDRESS;
	    pragma INTERFACE(C, MALLOC);
	    pragma IMPORT_FUNCTION(MALLOC, external=>"malloc",
		mechanism=>(VALUE),
		result_mechanism=>VALUE);
    begin
	return MALLOC(NUMBER_OF_BYTES);
    end;

begin
    declare
	-- Start the random number generator "at random"
	--
	procedure SRANDOM(SEED : INTEGER);
	    pragma INTERFACE(C, SRANDOM);
	    pragma IMPORT_PROCEDURE(SRANDOM, external=>"srandom",
		mechanism => value);
	function GETPID return INTEGER;
	    pragma INTERFACE(C, GETPID);
	    pragma IMPORT_FUNCTION(GETPID, external=>"getpid");
    begin
	SRANDOM(GETPID);
    end;
end;
