--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with ULTRIX_SOCKET, ULTRIX_FUNDAMENTALS;
use  ULTRIX_SOCKET, ULTRIX_FUNDAMENTALS;
package ULTRIX_NET_IF is

    -- Based on #include <net/if.h>

    IFNAMSIZ : constant := 16;

    type IFREQ_ADDR is
	record
	    IFR_NAME	: U_STR(1..IFNAMSIZ);
	    IFR_ADDR	: SOCKADDR;
	end record;
	for IFREQ_ADDR use
	record
	    IFR_NAME	at 0        range 0..IFNAMSIZ*8-1;
	    IFR_ADDR	at IFNAMSIZ range 0..16*8-1;
	end record;

    type IFDEVEA is
	record
	    IFR_NAME	: U_STR(1..IFNAMSIZ);
	    DEFAULT_PA	: U_STR(1..6);
	    CURRENT_PA	: U_STR(1..6);
	end record;
	for IFDEVEA'size use 28*8;
	for IFDEVEA use
	record
	    IFR_NAME	at 0 range 0..IFNAMSIZ*8-1;
	    DEFAULT_PA	at IFNAMSIZ   range 0..6*8-1;
	    CURRENT_PA	at IFNAMSIZ+6 range 0..6*8-1;
	end record;
    
    type IFCONF is
	record
	    LEN		: U_INT;
	    REQ		: U_ADDRESS;
	end record;
	for IFCONF use
	record
	    LEN		at 0 range 0..31;
	    REQ		at U_ADDRESS_SIZE/8 range 0..U_ADDRESS_SIZE-1;
			    -- align correctly
	end record;

end ULTRIX_NET_IF;
