--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with SYSTEM;
package ULTRIX_FUNDAMENTALS is

    U_ADDRESS_SIZE : constant :=
	    32
--	    +32*Boolean'pos(System."="(System.System_Name,System.DEC_OSF1_AXP))
	    ;

    type U_ADDRESS is new SYSTEM.ADDRESS;
	for U_ADDRESS'size use U_ADDRESS_SIZE;

    type U_CHAR is range 0..255;
	for U_CHAR'size use 8;

    type U_STR  is array(POSITIVE range <>) of U_CHAR;
	pragma PACK(U_STR);

    type U_SHORT is range 0..2**16-1;
	for U_SHORT'size use 16;

    type U_INT is range -2**31..2**31-1;
	for U_INT'size use 32;

    type INTEGER_MASK is array(INTEGER range <>) of BOOLEAN;
	pragma PACK(INTEGER_MASK);

    type MUST_BE_ZERO_TYPE is range 0..0;
	for MUST_BE_ZERO_TYPE'size use 32;

    type TIMEVAL_TYPE is
	record
	    SEC,
	    USEC    : INTEGER;
	end record;


    function IOCTL(
	FD	: INTEGER;
	REQUEST	: INTEGER;
	ARGP	: SYSTEM.ADDRESS) return INTEGER;
	pragma INTERFACE(C, IOCTL);
	pragma IMPORT_FUNCTION(IOCTL, external => "ioctl",
	    mechanism => (value, value, value));

    procedure PERROR(S : STRING);
	pragma INTERFACE(C, PERROR);
	pragma IMPORT_PROCEDURE(PERROR, external => "perror",
	    mechanism => reference);

    function WRITE(
	FD	: INTEGER;
	BUF	: SYSTEM.ADDRESS;
	NBYTES	: NATURAL)
	return INTEGER;
	pragma INTERFACE(C, WRITE);
	pragma IMPORT_FUNCTION(WRITE, external => "write",
	    mechanism => (value, value, value));

    function READ(
	FD	: INTEGER;
	BUF	: SYSTEM.ADDRESS;
	NBYTES	: NATURAL)
	return INTEGER;
	pragma INTERFACE(C, READ);
	pragma IMPORT_FUNCTION(READ, external => "read",
	    mechanism => (value, value, value));

    function SEND(
	FD	: INTEGER;
	BUF	: SYSTEM.ADDRESS;
	NBYTES	: NATURAL;
	FLAGS	: INTEGER)
	return INTEGER;
	pragma INTERFACE(C, SEND);
	pragma IMPORT_FUNCTION(SEND, external => "send",
	    mechanism => (value, value, value, value));

    procedure CLOSE(
	FD	: INTEGER);
	pragma INTERFACE(C, CLOSE);
	pragma IMPORT_PROCEDURE(CLOSE, external => "close",
	    mechanism => value);

    procedure SELECT_FDS(
	SELECTED    : out INTEGER;
	NUM_OF_FDS  : NATURAL;
	MASK_OF_READ_FDS    : in out INTEGER_MASK;
	MASK_OF_WRITE_FDS   : in out INTEGER_MASK;
	MASK_OF_EXCEP_FDS   : in out INTEGER_MASK;
	TIMEOUT     : TIMEVAL_TYPE);
	pragma INTERFACE(C, SELECT_FDS);
	pragma IMPORT_VALUED_PROCEDURE(SELECT_FDS, external => "select",
	    mechanism => (
		value,
		value, reference, reference, reference, reference));

    procedure SELECT_FDS_READ_ONLY(
	SELECTED    : out INTEGER;
	NUM_OF_FDS  : NATURAL;
	MASK_OF_READ_FDS    : in out INTEGER_MASK;
	MASK_OF_WRITE_FDS   : MUST_BE_ZERO_TYPE := 0;
	MASK_OF_EXCEP_FDS   : MUST_BE_ZERO_TYPE := 0;
	TIMEOUT     : TIMEVAL_TYPE);
	pragma INTERFACE(C, SELECT_FDS_READ_ONLY);
	pragma IMPORT_VALUED_PROCEDURE(SELECT_FDS_READ_ONLY, external => "select",
	    mechanism => (value,
		value, reference, value, value, reference));

end;
