--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with ULTRIX_FUNDAMENTALS, ULTRIX_DLI_VAR, ULTRIX_SOCKET, TEXT_IO;
use  ULTRIX_FUNDAMENTALS, ULTRIX_DLI_VAR, ULTRIX_SOCKET;
procedure ULTRIX_EXAMPLE_DLI_ETH is

    function DLI_ECONN(
	DEVNAME : DEVNAME_TYPE;
	DEVUNIT : U_SHORT;
	PTYPE   : U_SHORT;
	TADDR   : EADDR_TYPE;
	IOCTL   : U_CHAR)
	return INTEGER is

	SOCK	: INTEGER;
	OUT_BIND	: EADDR_SOCKADDR_DL;

    begin

	SOCK := SOCKET(AF_DLI, SOCK_DGRAM, DLPROTO_DLI);

	if SOCK < 0 then
	    PERROR("dli_eth, can't open DLI socket");
	    return (-1);
	end if;

	OUT_BIND :=
	    (dli_family =>
		AF_DLI,
	     dli_device =>
		(dli_devname  => DEVNAME,
		 dli_devnumber=> DEVUNIT),
	     dli_substructype =>
		DLI_ETHERNET,
	     dli_eaddr  =>
		(dli_ioctlflg => ioctl,
		 dli_protype  => ptype,
		 dli_target   => taddr,
		 dli_dest     => (others=>0)),
	     filler_must_be_zero =>
		(others => 0)
	    );

	if BIND(SOCK, OUT_BIND) < 0
	then
	    PERROR("dli_eth, can't bind DLI socket");
	    return (-1);
	end if;

	return SOCK;
    end;


    procedure MAIN is

	INBUF, OUTBUF   : U_STR(1..1500);
	TARGET_EADDR    : EADDR_TYPE;
	DEVNAME 	: DEVNAME_TYPE;
	DEVUNIT 	: U_SHORT;
	RSIZE		: INTEGER;
	SOCK		: INTEGER;
	PTYPE		: U_SHORT;
	OBSIZ		: INTEGER range 46..INTEGER'last;

    begin
	DEVNAME := (DEVNAME'range => ASCII.NUL);
	DEVNAME(1..2) := "ln";
	DEVUNIT := 0;

	declare
	    use TEXT_IO;
	    BUFFER : STRING(1..80);
	    LAST   : INTEGER;

	    TO_HEX : constant STRING(1..16)  := "0123456789ABCDEF";

	    function CHARACTER_TO_HEX(C : CHARACTER) return INTEGER is
	    begin
		if C in '0'..'9' then
		    return CHARACTER'pos(C)-CHARACTER'pos('0');
		elsif C in 'A'..'F' then
		    return CHARACTER'pos(C)-CHARACTER'pos('A')+10;
		elsif C in 'a'..'f' then
		    return CHARACTER'pos(C)-CHARACTER'pos('a')+10;
		else
		    PUT_LINE("bad character > " & C);
		    return 0;
		end if;
	    end;

	    function FROM_HEX(S : STRING) return INTEGER is
		V : INTEGER := 0;
	    begin
		for I in S'range loop
		    V := V*16+CHARACTER_TO_HEX(S(I));
		end loop;
		return V;
	    end;

	begin
	    PUT_LINE("Target: eg FF-FF-FF-FF-FF-FF");
	    GET_LINE(BUFFER, LAST);
	    for I in 1..6 loop
		TARGET_EADDR(I) := U_CHAR(FROM_HEX(BUFFER(3*I-2..3*I-1)));
		PUT(TO_HEX(1+INTEGER(TARGET_EADDR(I)) /   16));
		PUT(TO_HEX(1+INTEGER(TARGET_EADDR(I)) rem 16));
		if I /= 6 then PUT('-'); end if;
	    end loop;
	    NEW_LINE;
	end;

	PTYPE := 16#6006#;

	for I in OUTBUF'range loop OUTBUF(I) := U_CHAR(I rem 256); end loop;
	OBSIZ := OUTBUF'length;

	SOCK := DLI_ECONN(DEVNAME, DEVUNIT, PTYPE, TARGET_EADDR, DLI_NORMAL);
	if SOCK < 0 then
	    PERROR("dli_eth, dli_econn failed");
	    return;
	end if;

	if WRITE(SOCK, OUTBUF'address, OBSIZ) < 0
	then
	    PERROR("WRITE failed");
	    return;
	end if;

	RSIZE := READ(SOCK, INBUF'address, INBUF'length);
	if RSIZE < 0 then
	    PERROR("READ failed");
	    return;
	end if;

	if RSIZE = 0 then
	    TEXT_IO.PUT_LINE("Nothing read");
	else
	    TEXT_IO.PUT_LINE("Something read");
	end if;

	CLOSE(SOCK);
    end;

begin
    MAIN;
end;
