--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with ULTRIX_FUNDAMENTALS, --ERRNO,
     ULTRIX_DLI_VAR, ULTRIX_NET_IF, ULTRIX_SOCKET, LOGICAL_TO_BOOLEAN;
use  ULTRIX_FUNDAMENTALS, --ERRNO,
     ULTRIX_DLI_VAR, ULTRIX_NET_IF, ULTRIX_SOCKET;

with BUG, UNCHECKED_CONVERSION;

package body ETHERNET_IO is

    type REAL_IO_STATUS_TYPE is new INTEGER;
    type REAL_CHANNEL_TYPE   is
	record
	    SOCK    : INTEGER;
	    ESD     : EADDR_SOCKADDR_DL;
	end record;

    READ_TIMEOUT_REQUESTED : constant BOOLEAN
	:= LOGICAL_TO_BOOLEAN("FCTM_ETHERNET_READ_TIMEOUT", TRUE);

    BYTE_SWITCHED_PROTOCOL : constant
	:= (PROTOCOL rem 256)*256+PROTOCOL/256;


    type ACCESS_EADDR_TYPE is access EADDR_TYPE;
    function TO_ACCESS_EADDR_TYPE is
	new UNCHECKED_CONVERSION(SYSTEM.ADDRESS, ACCESS_EADDR_TYPE);

    type ULTRIXISED_PHI_TYPE is
	record
	    DESTINATION : EADDR_TYPE;
	    SOURCE	: EADDR_TYPE;
	    PROTOCOL    : U_SHORT;
	end record;
	for ULTRIXISED_PHI_TYPE use
	record
	    DESTINATION at  0 range 0..6*8-1;
	    SOURCE	at  6 range 0..6*8-1;
	    PROTOCOL    at 12 range 0..15;
	end record;


    procedure INIT_AS_OKAY(IO_STATUS : in out IO_STATUS_TYPE) is
    begin
	if IO_STATUS = null then
	    IO_STATUS := new REAL_IO_STATUS_TYPE;
	end if;
	IO_STATUS.all := 0;
    end;

    procedure ASSIGN(CHANNEL : in out CHANNEL_TYPE) is
	type VECTOR_OF_STRING2 is array(POSITIVE range <>) of STRING(1..2);

	ETHERNET_DEVICES    : constant VECTOR_OF_STRING2
			    := ("ln", "de", "qe");

	procedure DLI_ECONN(
	    CHANNEL : in out REAL_CHANNEL_TYPE;

	    DEVNAME : DEVNAME_TYPE;
	    DEVUNIT : U_SHORT;
	    PTYPE   : U_SHORT;
	    TADDR   : EADDR_TYPE;
	    IOCTL   : U_CHAR) is

	    SOCK	: INTEGER renames CHANNEL.SOCK;
	    OUT_BIND	: EADDR_SOCKADDR_DL renames CHANNEL.ESD;

	begin

	    SOCK := SOCKET(AF_DLI, SOCK_DGRAM, DLPROTO_DLI);

	    if SOCK < 0 then
		PERROR("dli_eth, can't open DLI socket");
		SOCK := -1;
		return;
	    end if;

	    OUT_BIND :=
		(dli_family =>
		    AF_DLI,
		 dli_device =>
		    (dli_devname  => DEVNAME,
		     dli_devnumber=> DEVUNIT),
		 dli_substructype =>
		    DLI_ETHERNET,
		 dli_eaddr  =>
		    (dli_ioctlflg => ioctl,
		     dli_protype  => ptype,
		     dli_target   => taddr,
		     dli_dest     => (others=>0)),
		 filler_must_be_zero =>
		    (others => 0)
		);

	    if BIND(SOCK, OUT_BIND) < 0
	    then
		PERROR("dli_eth, can't bind DLI socket");
		CLOSE(SOCK);
		SOCK := -1;
		return;
	    end if;

	end;

    begin
	if CHANNEL = null then
	    CHANNEL := new REAL_CHANNEL_TYPE;
	end if;

	for REPORT_FAILURE in FALSE..TRUE loop
	    for DEVUNIT in U_SHORT range 0..7 loop
		for I in ETHERNET_DEVICES'range loop
		    DLI_ECONN(
			CHANNEL => CHANNEL.all,
			DEVNAME => ETHERNET_DEVICES(I)&
			    (ETHERNET_DEVICES(I)'length+1..
			     DEVNAME_TYPE'length=>ASCII.NUL),
			DEVUNIT => DEVUNIT,
			PTYPE   => BYTE_SWITCHED_PROTOCOL,
			TADDR   => (others => 0),
			IOCTL   => DLI_DEFAULT);
		    if CHANNEL.SOCK >= 0 then return; end if;
		    if REPORT_FAILURE then
			BUG("Unable to connect to ethernet, tried "&
			    ETHERNET_DEVICES(I)&
			    CHARACTER'val(CHARACTER'pos('0')+DEVUNIT));
		    end if;
		end loop;
	    end loop;
	end loop;

    end;

    procedure STARTUP(CHANNEL : in out CHANNEL_TYPE) is
    begin
	null;
    end;

    function GET_ETHERNET_PHYSICAL_ADDRESS(CHANNEL : CHANNEL_TYPE)
	return ETHERNET_PHYSICAL_ADDRESS_TYPE is

	ANSWER : ETHERNET_PHYSICAL_ADDRESS_TYPE := (others => 0);

    begin

     TRY:
	declare
	    type VECTOR_OF_IFREQ_ADDR is array(POSITIVE range <>) of IFREQ_ADDR;
		pragma COMPONENT_ALIGNMENT(STORAGE_UNIT, VECTOR_OF_IFREQ_ADDR);

	    DEVEA   : IFDEVEA;				pragma VOLATILE(DEVEA);
	    IFREQS  : VECTOR_OF_IFREQ_ADDR(1..32);   	pragma VOLATILE(IFREQS);
	    IFC	    : IFCONF;				pragma VOLATILE(IFC);
	    S	    : INTEGER;

	    SIOCGIFCONF   : constant := -1073190636;
	    SIOCRPHYSADDR : constant := -1071879908;

	    function STRCMP(S1,S2 : U_STR) return BOOLEAN is
	    begin
		for I in S1'range loop
		    if S1(I) /= S2(I) then return FALSE; end if;
		    if S1(I) = 0 then return TRUE; end if;
		end loop;
		return TRUE;
	    end;

	begin
	    DEVEA := (IFR_NAME => (others=>0),
		      DEFAULT_PA|CURRENT_PA => (others=>0));

	    -- Get a socket
	    S := SOCKET(AF_UNIX, SOCK_DGRAM, 0);
	    if S < 0 then
		PERROR("can't open DLI socket to get address");
		goto END_TRY;
	    end if;

	    -- Find out about it
	    IFC.REQ := U_ADDRESS(IFREQS'address);
	    IFC.LEN := IFREQS'size/8;
	    if IOCTL(S, SIOCGIFCONF, IFC'address) < 0 then
		PERROR("siocgifconf trying to get address");
		goto END_TRY;
	    end if;

	    -- Loop over the IFREQ's
	    for I in IFREQS'range loop
		declare
		    IFR : IFREQ_ADDR renames IFREQS(I);
		begin

		    if not STRCMP(DEVEA.IFR_NAME,IFR.IFR_NAME) then
			DEVEA.IFR_NAME := IFR.IFR_NAME;

			-- read the address of the interface

			if IOCTL(S, SIOCRPHYSADDR, DEVEA'ADDRESS) < 0
			then
--			    declare
--			    	use ERRNO;
--			    	E : ERRNO_TYPE := GET_ERRNO;
--			    begin
--				if  E /= EOPNOTSUPP
--				and E /= EINVAL
--				and E /= ENXIO
--				then
--				    PERROR("unexpected error trying to get address");
--				end if;
--			    end;
			    null;
			else
			    for I in 1..6 loop
				ANSWER(I) := INTEGER(DEVEA.CURRENT_PA(I));
			    end loop;
			    goto END_TRY;
			end if;
		    end if;
		end;
	    end loop;

        end TRY;
<<END_TRY>>
	return ANSWER;
    end;

    procedure SYNC_AND_WRITE(
	IO_STATUS   : in IO_STATUS_TYPE;
	CHANNEL     : in CHANNEL_TYPE;
	NUM_BYTES   : in NATURAL;
	BYTES	    : in SYSTEM.ADDRESS;
	DESTINATION : in ETHERNET_PHYSICAL_ADDRESS_TYPE) is

	ESD	    : EADDR_SOCKADDR_DL renames CHANNEL.ESD;
	ESD_TARGET  : ETHERNET_PHYSICAL_ADDRESS_TYPE;
	    for ESD_TARGET use at ESD.DLI_EADDR.DLI_TARGET'address;

    begin
	-- Set the destination...
	--
	ESD_TARGET := DESTINATION;

	-- Send it
	if SENDTO(CHANNEL.SOCK, BYTES, NUM_BYTES, 0, ESD) < 0
	then
	    PERROR("Transmission error");
	end if;
    end;

    function DID_READ_NOW(
	IO_STATUS   : in IO_STATUS_TYPE;
	CHANNEL     : in CHANNEL_TYPE;
	NUM_BYTES   : in NATURAL;
	BYTES       : in SYSTEM.ADDRESS;
	PKT_HEAD    : in SYSTEM.ADDRESS) return BOOLEAN is

	ULTRIXISED_PHI : ULTRIXISED_PHI_TYPE;
	    for ULTRIXISED_PHI use at PKT_HEAD;

	SOCK	    : INTEGER		renames CHANNEL.SOCK;
	FROM	    : EADDR_SOCKADDR_DL renames CHANNEL.ESD;
	FROMLEN     : INTEGER := SIZEOF_EADDR_SOCKADDR_DL;

	CC	    : INTEGER;

	SELECTED    : INTEGER;
	MASK_OF_READ_FDS : INTEGER_MASK(0..SOCK);

    begin

	FROM.DLI_FAMILY := AF_DLI;
	MASK_OF_READ_FDS := (others=>FALSE);
	MASK_OF_READ_FDS(SOCK) := TRUE;

	if READ_TIMEOUT_REQUESTED then
	    SELECT_FDS_READ_ONLY(SELECTED, SOCK+1, MASK_OF_READ_FDS,
		TIMEOUT => TIMEVAL_TYPE'(0,0));
	    if SELECTED <= 0 then
		return false;
	    end if;
	end if;

	RECVFROM(CC, SOCK, BYTES, NUM_BYTES, 0, FROM, FROMLEN);

	if FROMLEN /= SIZEOF_EADDR_SOCKADDR_DL then
	    BUG("Reception error : Bad FROMLEN");
	end if;

	if CC < 0 then
	    PERROR("Reception error");
	    -- raise ?
	end if;

	ULTRIXISED_PHI.DESTINATION := FROM.DLI_EADDR.DLI_DEST;
	ULTRIXISED_PHI.SOURCE      := FROM.DLI_EADDR.DLI_TARGET;
	ULTRIXISED_PHI.PROTOCOL    := PROTOCOL; -- HACK!

	return CC > 0;
    end;

begin
    if ULTRIXISED_PHI_TYPE'size /= PACKET_HEADER_INFORMATION_TYPE'size then
	raise PROGRAM_ERROR;
    end if;
end;
