--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with ULTRIX_FUNDAMENTALS, SYSTEM;
use  ULTRIX_FUNDAMENTALS;
package ULTRIX_DLI_VAR is

--/*	@(#)dli_var.h	2.6	(ULTRIX)	@(#)dli_var.h	2.6	*/

    DLI_MAXPROC : constant INTEGER := 32;

    DLI_SENDSPACE : constant INTEGER := 1024*2;
    DLI_RECVSPACE : constant INTEGER := 1024*4;

    DLPROTO_DLI     : constant INTEGER := 0;
    DLPROTO_CSMACD  : constant INTEGER := 1;
    DLPROTO_LOOP    : constant INTEGER := 2;
    DLPROTO_DDCMP   : constant INTEGER := 3;
    DLPROTO_FDDI    : constant INTEGER := 4;
    DLPROTO_DM	    : constant INTEGER := 5;
    DLPROTO_WDA     : constant INTEGER := 6;
    DLPROTO_HDLC    : constant INTEGER := 7;
    DLPROTO_HDLCM   : constant INTEGER := 8;

    DLI_EXCLUSIVE   : constant U_CHAR := 001;
    DLI_NORMAL	    : constant U_CHAR := 002;
    DLI_DEFAULT     : constant U_CHAR := 004;

    DLI_ETHERNET    : constant U_CHAR := 0;
    DLI_POINTOPOINT : constant U_CHAR := 1;
    DLI_802	    : constant U_CHAR := 2;
    DLI_LOOP	    : constant U_CHAR := 3;
    DLI_HDLC	    : constant U_CHAR := 4;

    DLI_EADDRSIZE   : constant INTEGER := 6;
    DLI_DEVSIZE     : constant INTEGER := 16;

    subtype DEVNAME_TYPE is STRING(1..DLI_DEVSIZE+1);
    type EADDR_TYPE   is array(1..DLI_EADDRSIZE) of U_CHAR;

    type dli_devid is
	record
	    dli_devname     : DEVNAME_TYPE;
	    dli_devnumber   : u_short;
	end record;

    type sockaddr_edl is
	record
	    dli_ioctlflg    : u_char;
	    dli_protype     : u_short;
	    dli_target	    : EADDR_TYPE;
	    dli_dest	    : EADDR_TYPE;
	end record;

    type eaddr_sockaddr_dl is
	record
	    dli_family		: u_short;
	    dli_device		: dli_devid;
	    dli_substructype	: u_char;
	    dli_eaddr		: sockaddr_edl;
	    filler_must_be_zero : u_str(40..143);
	end record;
	for eaddr_sockaddr_dl'size use 144*8;


    SIZEOF_EADDR_SOCKADDR_DL : constant INTEGER := (EADDR_SOCKADDR_DL'size+7)/8;
    subtype SIZEOF_EADDR_SOCKADDR_DL_SUBTYPE is
	INTEGER range SIZEOF_EADDR_SOCKADDR_DL..SIZEOF_EADDR_SOCKADDR_DL;

    function BIND(
	SOCK	: INTEGER;
	NAME	: EADDR_SOCKADDR_DL;
	NAMELEN : SIZEOF_EADDR_SOCKADDR_DL_SUBTYPE := SIZEOF_EADDR_SOCKADDR_DL)
	return INTEGER;
	pragma INTERFACE(C, BIND);
	pragma IMPORT_FUNCTION(BIND, external => "bind",
	    mechanism => (value, reference, value));

    function SENDTO(
	SOCK	: INTEGER;
	MSG	: SYSTEM.ADDRESS;
	LEN	: NATURAL;
	FLAGS	: INTEGER;
	TO	: EADDR_SOCKADDR_DL;
	TOLEN	: SIZEOF_EADDR_SOCKADDR_DL_SUBTYPE := SIZEOF_EADDR_SOCKADDR_DL)
	return INTEGER;
	pragma INTERFACE(C, SENDTO);
	pragma IMPORT_FUNCTION(SENDTO, external => "sendto",
	    mechanism => (value, value, value, value, reference, value));

    procedure RECVFROM(
	CC	: out INTEGER;
	SOCK	: INTEGER;
	MSG	: SYSTEM.ADDRESS;
	LEN	: NATURAL;
	FLAGS	: INTEGER;
	FROM	: in out EADDR_SOCKADDR_DL;
	FROMLEN	: in out INTEGER);
	pragma INTERFACE(C, RECVFROM);
	pragma IMPORT_VALUED_PROCEDURE(RECVFROM, external => "recvfrom",
	    mechanism => (
		value,
		value, value, value, value,
		reference, reference));

end;
