--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with LOGICAL_TO_BOOLEAN;
with BUG, UNCHECKED_CONVERSION;

package body ETHERNET_IO is

    -- Completions
    type REAL_IO_STATUS_TYPE is
	new INTEGER;

    type REAL_CHANNEL_TYPE   is
	record
	    null;
	end record;

    -- Local stuff
    --
    BYTE_SWITCHED_PROTOCOL : constant
	:= (PROTOCOL rem 256)*256+PROTOCOL/256;

    package C_Interface is

	procedure FCTM_ETHERNET_IO_ASSIGN;
	    pragma Interface(C, FCTM_ETHERNET_IO_ASSIGN);
	    pragma Import_Procedure(FCTM_ETHERNET_IO_ASSIGN,
		external  => "fctm_ethernet_io_assign");

	procedure FCTM_GET_ETHERNET_PHYSICAL_ADDRESS(
	    PA : out ETHERNET_PHYSICAL_ADDRESS_TYPE);
	    pragma Interface(C, FCTM_GET_ETHERNET_PHYSICAL_ADDRESS);
	    pragma Import_Procedure(FCTM_GET_ETHERNET_PHYSICAL_ADDRESS,
		external  => "fctm_get_ethernet_physical_address",
		mechanism => (reference));

	procedure FCTM_ETHERNET_WRITE(
	    NUM_BYTES   : in NATURAL;
	    BYTES       : in SYSTEM.ADDRESS;
	    DESTINATION : in ETHERNET_PHYSICAL_ADDRESS_TYPE);
	    pragma Interface(C, FCTM_ETHERNET_WRITE);
	    pragma Import_Procedure(FCTM_ETHERNET_WRITE,
		external  => "fctm_ethernet_write",
		mechanism => (value,value,reference));

	function FCTM_ETHERNET_READ(
	    NUM_BYTES   : in NATURAL;
	    BYTES       : in SYSTEM.ADDRESS;
	    PKT_HEAD    : in SYSTEM.ADDRESS)
	    return Integer;
	    pragma Interface(C, FCTM_ETHERNET_READ);
	    pragma Import_Function(FCTM_ETHERNET_READ,
		external  => "fctm_ethernet_read",
		mechanism => (value,value,value));

    end C_Interface;


    procedure INIT_AS_OKAY(IO_STATUS : in out IO_STATUS_TYPE) is
    begin
	if IO_STATUS = null then IO_STATUS := new REAL_IO_STATUS_TYPE; end if;
	IO_STATUS.all := 0;
    end;

    procedure ASSIGN(CHANNEL : in out CHANNEL_TYPE) is
    begin
	if CHANNEL = null then CHANNEL := new REAL_CHANNEL_TYPE; end if;
	C_Interface.FCTM_ETHERNET_IO_ASSIGN;
    end ASSIGN;

    procedure STARTUP(CHANNEL : in out CHANNEL_TYPE) is
    begin
	null;
    end STARTUP;

    function GET_ETHERNET_PHYSICAL_ADDRESS(
	CHANNEL : CHANNEL_TYPE)
	return ETHERNET_PHYSICAL_ADDRESS_TYPE
    is
	PA : ETHERNET_PHYSICAL_ADDRESS_TYPE;
    begin
	C_Interface.FCTM_GET_ETHERNET_PHYSICAL_ADDRESS(PA);
	return PA;
    end GET_ETHERNET_PHYSICAL_ADDRESS;

    procedure SYNC_AND_WRITE(
	IO_STATUS   : in IO_STATUS_TYPE;
	CHANNEL     : in CHANNEL_TYPE;
	NUM_BYTES   : in NATURAL;
	BYTES	    : in SYSTEM.ADDRESS;
	DESTINATION : in ETHERNET_PHYSICAL_ADDRESS_TYPE)
    is
    begin
	C_Interface.FCTM_ETHERNET_WRITE(
	    NUM_BYTES,BYTES,DESTINATION);
    end SYNC_AND_WRITE;

    function DID_READ_NOW(
	IO_STATUS   : in IO_STATUS_TYPE;
	CHANNEL     : in CHANNEL_TYPE;
	NUM_BYTES   : in NATURAL;
	BYTES       : in SYSTEM.ADDRESS;
	PKT_HEAD    : in SYSTEM.ADDRESS) return BOOLEAN
    is
    begin
	return C_Interface.FCTM_ETHERNET_READ(
	    NUM_BYTES, BYTES, PKT_HEAD) /= 0;
    end DID_READ_NOW;

end ETHERNET_IO;
