--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    IS_DEMO_PKG,
    LOGICAL_TO_BOOLEAN, LOGICAL_TO_FLOAT, SYSTEM_INTERFACE, NYI,
    SCALE_TYPE_MATH_LIB,
    SCALAR_PHYSICS, WORLD_PHYSICS, OBJECT_PHYSICS,
    OBJECTS, INFO_MANAGER, APPEARANCE_MANAGER,
    CONTROLLED_OBJECT, VIEW_MANAGER,
    MAIN_SIMULATION;

pragma ELABORATE(
    IS_DEMO_PKG,
    LOGICAL_TO_BOOLEAN, LOGICAL_TO_FLOAT, SYSTEM_INTERFACE, NYI,
    SCALE_TYPE_MATH_LIB,
    SCALAR_PHYSICS, WORLD_PHYSICS, OBJECT_PHYSICS,
    OBJECTS, INFO_MANAGER, APPEARANCE_MANAGER,
    CONTROLLED_OBJECT, VIEW_MANAGER);

package body WORLD_MANAGER is


    -- Make unary minus visible
    --
    function "-"(RIGHT : OBJECTS.OBJECT_LOCATION_COORDINATE)
	return OBJECTS.OBJECT_LOCATION_COORDINATE renames OBJECTS."-";


    SIMPLE_WORLD : constant BOOLEAN
	:= LOGICAL_TO_BOOLEAN("FCTM_SIMPLE_WORLD", FALSE);


    HORIZON_APPEARANCE_INFO : constant INFO_MANAGER.APPEARANCE_INFO_TYPE
	:= APPEARANCE_MANAGER.CREATE;

    HORIZON_APPEARANCE : constant APPEARANCE_MANAGER.ACCESS_APPEARANCE_TYPE
	:= APPEARANCE_MANAGER.TO_ACCESS_APPEARANCE_TYPE(HORIZON_APPEARANCE_INFO);

    SHADOW_APPEARANCE_INFO : constant INFO_MANAGER.APPEARANCE_INFO_TYPE
	:= APPEARANCE_MANAGER.CREATE;

    SHADOW_APPEARANCE : constant APPEARANCE_MANAGER.ACCESS_APPEARANCE_TYPE
	:= APPEARANCE_MANAGER.TO_ACCESS_APPEARANCE_TYPE(SHADOW_APPEARANCE_INFO);

    ORIENTATION_MARKS_APPEARANCE_INFO : constant INFO_MANAGER.APPEARANCE_INFO_TYPE
        := APPEARANCE_MANAGER.CREATE;

    ORIENTATION_MARKS_APPEARANCE : constant APPEARANCE_MANAGER.ACCESS_APPEARANCE_TYPE
        := APPEARANCE_MANAGER.TO_ACCESS_APPEARANCE_TYPE(ORIENTATION_MARKS_APPEARANCE_INFO);


    NUMBER_OF_MOUNTAIN_RANGES : constant INTEGER := 7;

    MOUNTAIN_APPEARANCE_INFO :
	array(1..NUMBER_OF_MOUNTAIN_RANGES) of INFO_MANAGER.APPEARANCE_INFO_TYPE
	:= (others => APPEARANCE_MANAGER.CREATE);

    MOUNTAIN_APPEARANCE :
	array(1..NUMBER_OF_MOUNTAIN_RANGES) of
	APPEARANCE_MANAGER.ACCESS_APPEARANCE_TYPE;

    MOUNTAIN_APPEARANCE_SET : BOOLEAN := FALSE;

    NS_RUNWAY_APPEARANCE_INFO,
    EW_RUNWAY_APPEARANCE_INFO : constant INFO_MANAGER.APPEARANCE_INFO_TYPE
	:= APPEARANCE_MANAGER.CREATE;

    NS_RUNWAY_APPEARANCE : constant APPEARANCE_MANAGER.ACCESS_APPEARANCE_TYPE
	:= APPEARANCE_MANAGER.TO_ACCESS_APPEARANCE_TYPE(NS_RUNWAY_APPEARANCE_INFO);

    EW_RUNWAY_APPEARANCE : constant APPEARANCE_MANAGER.ACCESS_APPEARANCE_TYPE
	:= APPEARANCE_MANAGER.TO_ACCESS_APPEARANCE_TYPE(EW_RUNWAY_APPEARANCE_INFO);

    WORLD_ORIGIN : constant WORLD_PHYSICS.POSITION := (0.0, 0.0, 0.0);
    NOT_MOVING	 : constant WORLD_PHYSICS.VELOCITY := (0.0, 0.0, 0.0);


    procedure CREATE is
	use OBJECTS, WORLD_PHYSICS, SCALAR_PHYSICS;
	HR : ACCESS_OBJECT_TYPE;
	SW : ACCESS_OBJECT_TYPE;
	OM : ACCESS_OBJECT_TYPE;
	RW : ACCESS_OBJECT_TYPE;

	STATIONARY_OBJECTS : ACCESS_OBJECT_TYPE;

	function NOTE(OBJECT : ACCESS_OBJECT_TYPE) return ACCESS_OBJECT_TYPE is
	begin
	    OBJECT.NEXT := STATIONARY_OBJECTS;
	    STATIONARY_OBJECTS := OBJECT;
	    return OBJECT;
	end;

    begin
	-- like the rest of this landscape, it comes from FLIGHT, but for the
	-- mountains I am letting the code do the conversions necessary.  The
	-- SPREAD_FACTOR though spreads the mountains out further across the
	-- landscape, so that at jet speeds it still takes a while to get to
	-- them...
	--
	declare
	    HORIZONTAL_SPREAD_FACTOR : constant SYSTEM_INTERFACE.LONGEST_FLOAT
		:= LOGICAL_TO_FLOAT("FCTM_MOUNTAIN_HSF", 20.0);
	    SIZE_SPREAD_FACTOR : constant SYSTEM_INTERFACE.LONGEST_FLOAT
		:= LOGICAL_TO_FLOAT("FCTM_MOUNTAIN_SSF", 10.0);

	    type FEET is new FLOAT;
	    type LOCATION is record I,K,J : FEET; end record;

	    MR		    : INTEGER := 0;
	    CONTINUATION    : BOOLEAN := FALSE;
	    FIRST_I,
	    FIRST_J	    : OBJECTS.OBJECT_LOCATION_COORDINATE;

	    function "+"(F : FEET; I : INTEGER) return FEET is
	    begin
		return F + FEET(I);
	    end;

	    function "-"(F : FEET; I : INTEGER) return FEET is
	    begin
		return F - FEET(I);
	    end;

	    function TO_METRES(F : FEET) return METRES is
	    begin
		return METRES(F*(36.0/39.6/3.0));
	    end;

	    function TO_OLC(F : FEET)
		return OBJECTS.OBJECT_LOCATION_COORDINATE is
	    begin
		return
		    OBJECTS.OBJECT_LOCATION_COORDINATE(
			TO_METRES(F)*SCALE_TYPE(HORIZONTAL_SPREAD_FACTOR));
	    end;

	    procedure DRAW_MOUNTAIN(
		L		: LOCATION;
		HEIGHT_IN_FEET	: INTEGER;
		CONTINUED	: BOOLEAN := FALSE) is

		use APPEARANCE_MANAGER;
		SOME_MOUNTAIN : ACCESS_OBJECT_TYPE;
		X : constant METRES := TO_METRES(FEET(HEIGHT_IN_FEET))*
					SCALE_TYPE(SIZE_SPREAD_FACTOR);
		THIS_I, THIS_J	: OBJECTS.OBJECT_LOCATION_COORDINATE;
		BIAS_I, BIAS_J	: METRES := 0.0;
	    begin
		THIS_I := TO_OLC(-L.I);
		THIS_J := TO_OLC(L.J);

		if not CONTINUATION then
		    MR := MR+1;

		    FIRST_I := THIS_I;
		    FIRST_J := THIS_J;

		    SOME_MOUNTAIN := NOTE(CREATE(NONE_NEEDED, GROUND, 0,
			LOCATION    => OBJECTS.OBJECT_LOCATION'(
					    FIRST_I,
					    FIRST_J,
					    TO_OLC(L.K)),
			ORIENTATION => USUAL_POSITION_BASIS,
			VELOCITY    => NOT_MOVING
			));

		    if not MOUNTAIN_APPEARANCE_SET then
			MOUNTAIN_APPEARANCE_INFO(MR) :=
			    APPEARANCE_MANAGER.CREATE;
			MOUNTAIN_APPEARANCE(MR) :=
			    APPEARANCE_MANAGER.TO_ACCESS_APPEARANCE_TYPE(
				MOUNTAIN_APPEARANCE_INFO(MR));
		    end if;

		    SOME_MOUNTAIN.APPEARANCE_INFO :=
			MOUNTAIN_APPEARANCE_INFO(MR);

		end if;

		declare
		    use OBJECTS;
		begin
		    BIAS_I := METRES(THIS_I-FIRST_I);
		    BIAS_J := METRES(THIS_J-FIRST_J);
		end;

		if not MOUNTAIN_APPEARANCE_SET then

		    if CONTINUATION then
			ADD_SUBPICTURE(MOUNTAIN_APPEARANCE(MR));
		    end if;

		    if SIMPLE_WORLD then
			declare
			    I : constant SCALE_TYPE := SCALE_TYPE(THIS_I);
			    J : constant SCALE_TYPE := SCALE_TYPE(THIS_J);
			    H : constant SCALE_TYPE :=
				SCALE_TYPE_MATH_LIB.SQRT(I*I+J*J);
			    SI : SCALE_TYPE := (-J)/H;
			    SJ : SCALE_TYPE := I/H;
			begin
			    ADD_POINTS(MOUNTAIN_APPEARANCE(MR),
				VECTOR_OF_POSITION'(
				    (BIAS_I-X*SI, BIAS_J-X*SJ, 0.0),
				    (BIAS_I+ 0.0, BIAS_J+ 0.0,   X),
				    (BIAS_I+X*SI, BIAS_J+X*SJ, 0.0)));
			end;
		    else
			ADD_POINTS(MOUNTAIN_APPEARANCE(MR),
			    VECTOR_OF_POSITION'(
				(BIAS_I-  X, BIAS_J+  X, 0.0),
				(BIAS_I+0.0, BIAS_J+0.0,   X),
				(BIAS_I+  X, BIAS_J-  X, 0.0)));
			ADD_SUBPICTURE(MOUNTAIN_APPEARANCE(MR));
			ADD_POINTS(MOUNTAIN_APPEARANCE(MR),
			    VECTOR_OF_POSITION'(
				(BIAS_I  -X, BIAS_J  -X, 0.0),
				(BIAS_I+0.0, BIAS_J+0.0,   X),
				(BIAS_I+  X, BIAS_J+  X, 0.0)));
		    end if;

		    if not CONTINUED then
			FINISH_CREATING_SUBPICTURES(MOUNTAIN_APPEARANCE(MR));
		    end if;
		end if;

		CONTINUATION := CONTINUED;
	    end;

	begin
	    draw_mountain(location'(5280.0 * 1.0, 0.0, 5280.0 * 1.0), 1000);  --{  Mt. Gorin  }

	    draw_mountain(location'(5280.0 * 30.0, 0.0, 5280.0 * 0.0), 5500);  --{  Mt. Flight  }

	    draw_mountain(location'(5280.0 * 6.0, 0.0, 5280.0 * 12.0), 8000);  --{  Mt. Griffin  }

	    draw_mountain(location'(5280.0 * (-18.0), 0.0, 5280.0 * 21.0), 10000, true);                  --{  Pavanello Chain  }
	    draw_mountain(location'(5280.0 * (-18.0) - 12000, 0.0, 5280.0 * 21.0 - 5000), 6000);

	    draw_mountain(location'(5280.0 * (-18.0), 0.0, 5280.0 * 9.0), 9000);   --{  Mt. Roth  }

	    draw_mountain(location'(5280.0 * (-9.0), 0.0, 5280.0 * (-9.0)), 8000, true);                  --{  Buehler Chain  }
	    draw_mountain(location'(5280.0 * (-9.0) + 6000, 0.0, 5280.0 * (-9.0) + 8000), 3000, true);
	    draw_mountain(location'(5280.0 * (-9.0) + 2000, 0.0, 5280.0 * (-9.0) - 7000), 5000);

	    draw_mountain(location'(5280.0 * (-3.0), 0.0, 5280.0 * (-12.0)), 14000);  --{  Mt. McKinley  }

	    MOUNTAIN_APPEARANCE_SET := TRUE;
        end;

	HR := NOTE(CREATE(NONE_NEEDED, GROUND, 0,
		LOCATION    => (0.0, 0.0, 0.0),
		ORIENTATION => USUAL_POSITION_BASIS,
		VELOCITY    => NOT_MOVING
		));
	HR.APPEARANCE_INFO := HORIZON_APPEARANCE_INFO;
	VIEW_MANAGER.HORIZON := HR;

	SW := NOTE(CREATE(NONE_NEEDED, GROUND, 0,
		LOCATION    => (0.0, 0.0, 0.0),
		ORIENTATION => USUAL_POSITION_BASIS,
		VELOCITY    => NOT_MOVING
		));
	SW.APPEARANCE_INFO := SHADOW_APPEARANCE_INFO;
	VIEW_MANAGER.SHADOW := SW;

	OM := CREATE(NONE_NEEDED, GROUND, 0,	-- deliberately not noted
                LOCATION    => (0.0, 0.0, 0.0), -- since specially drawn
                ORIENTATION => USUAL_POSITION_BASIS,
                VELOCITY    => NOT_MOVING
                );
        OM.APPEARANCE_INFO := ORIENTATION_MARKS_APPEARANCE_INFO;
        VIEW_MANAGER.ORIENTATION_MARKS := OM;

	RW := NOTE(CREATE(NONE_NEEDED, RUNWAY, 0,
		LOCATION    => (0.0, 0.0, 0.0),
		ORIENTATION => USUAL_POSITION_BASIS,
		VELOCITY    => NOT_MOVING
		));
	RW.APPEARANCE_INFO := NS_RUNWAY_APPEARANCE_INFO;

	RW := NOTE(CREATE(NONE_NEEDED, RUNWAY, 0,
		LOCATION    => (0.0, 0.0, 0.0),
		ORIENTATION => USUAL_POSITION_BASIS,
		VELOCITY    => NOT_MOVING
		));
	RW.APPEARANCE_INFO := EW_RUNWAY_APPEARANCE_INFO;

	-- Start the simulation running
	--
	MAIN_SIMULATION.OBJECT_SYNC.START(STATIONARY_OBJECTS);

    end;

    procedure DELETE is
    begin
	NYI("WORLD_MANAGER.DELETE", CONTINUE=>TRUE);
    end;

begin
    declare
	use APPEARANCE_MANAGER, SCALAR_PHYSICS;

	HORIZON_DISTANCE : constant METRES := VIEW_MANAGER.HORIZON_DISTANCE;
	SHADOW_DISTANCE  : METRES;

    begin
	ADD_POINTS(HORIZON_APPEARANCE,
	    VECTOR_OF_POSITION'(
	    (-HORIZON_DISTANCE,  -HORIZON_DISTANCE, 0.0),
	    (-HORIZON_DISTANCE,   HORIZON_DISTANCE, 0.0),
	    ( HORIZON_DISTANCE,   HORIZON_DISTANCE, 0.0),
	    ( HORIZON_DISTANCE,  -HORIZON_DISTANCE, 0.0),
	    (-HORIZON_DISTANCE,  -HORIZON_DISTANCE, 0.0))
	    );
	FINISH_CREATING_SUBPICTURES(HORIZON_APPEARANCE);

	-- now a couple of squares around the viewer so you can see where
	-- the ground is
	--
	if not IS_DEMO_PKG.IS_DEMO then
	    SHADOW_DISTANCE := 2.0E2;
	    ADD_POINTS(SHADOW_APPEARANCE,
		VECTOR_OF_POSITION'(
		(-SHADOW_DISTANCE,  -SHADOW_DISTANCE, 0.0),
		(-SHADOW_DISTANCE,   SHADOW_DISTANCE, 0.0),
		( SHADOW_DISTANCE,   SHADOW_DISTANCE, 0.0),
		( SHADOW_DISTANCE,  -SHADOW_DISTANCE, 0.0),
		(-SHADOW_DISTANCE,  -SHADOW_DISTANCE, 0.0))
		);
	    ADD_SUBPICTURE(SHADOW_APPEARANCE);
	    SHADOW_DISTANCE := 1.0E2;
	    ADD_POINTS(SHADOW_APPEARANCE,
		VECTOR_OF_POSITION'(
		(-SHADOW_DISTANCE,  -SHADOW_DISTANCE, 0.0),
		(-SHADOW_DISTANCE,   SHADOW_DISTANCE, 0.0),
		( SHADOW_DISTANCE,   SHADOW_DISTANCE, 0.0),
		( SHADOW_DISTANCE,  -SHADOW_DISTANCE, 0.0),
		(-SHADOW_DISTANCE,  -SHADOW_DISTANCE, 0.0))
		);
	end if;
	FINISH_CREATING_SUBPICTURES(SHADOW_APPEARANCE);

	-- The orientation marks.  They are placed a long way out to cope with
	-- the observer being slightly away from the centre of the craft.
	--
	declare
	    SIN_COS_45	: constant SCALE_TYPE	:= 0.85090352453;
	    HALF	: constant SCALE_TYPE	:= 0.5;

	    L		: constant METRES
		    := METRES(LOGICAL_TO_FLOAT("FCTM_OM_LENGTH",     200.0));

	    D		: constant METRES
		    := METRES(LOGICAL_TO_FLOAT("FCTM_OM_DISTANCE", 10000.0));

	    D45 	: constant METRES	:= D*SIN_COS_45;
	    L45 	: constant METRES	:= L*SIN_COS_45;

	    procedure MAKE_SUBPICTURE(VP : VECTOR_OF_POSITION) is
	    begin
		ADD_POINTS(ORIENTATION_MARKS_APPEARANCE, VP);
		ADD_SUBPICTURE(ORIENTATION_MARKS_APPEARANCE);
	    end;

	begin
	    MAKE_SUBPICTURE(				-- front top of sight
		((0.0, D,  L*HALF),
		 (0.0, D,  L*HALF+L)));
	    MAKE_SUBPICTURE(				-- front bottom of sight
		((0.0, D, -L*HALF),
		 (0.0, D, -L*HALF-L)));

	    MAKE_SUBPICTURE(				-- 45 up
		((0.0, D45,     D45),
		 (0.0, D45-L45, D45+L45)));

	    MAKE_SUBPICTURE(				-- 90 up
		((-L45*HALF, -L45, D),
		 (0.0,        0.0, D),
		 ( L45*HALF, -L45, D)));

	    MAKE_SUBPICTURE(				-- rear
		((0.0, -D, -L*HALF),
		 (0.0, -D,  L*HALF)));

	    for LEFT_OR_RIGHT in 0..1 loop		-- sides
		declare
		    FLIP     : SCALE_TYPE := SCALE_TYPE(LEFT_OR_RIGHT*2-1);
		    FD	     : METRES := D*FLIP;
		    FD45     : METRES := D45*FLIP;
		begin
		    MAKE_SUBPICTURE(				-- straight out
			((FD, 0.0,  L*HALF),
			 (FD, 0.0,  0.0),
			 (FD, L,    0.0)));
		    MAKE_SUBPICTURE(				-- 45 up
			((FD45+L45*HALF*FLIP, 0.0,   D45-L45*HALF),
			 (FD45,               0.0,   D45),
			 (FD45,               L,     D45)));
		end;
	    end loop;

	    FINISH_CREATING_SUBPICTURES(ORIENTATION_MARKS_APPEARANCE);
	end;

	-- The runways
	if SIMPLE_WORLD then
	    ADD_POINTS(NS_RUNWAY_APPEARANCE,
		VECTOR_OF_POSITION'(
		(   0.0, -250.0, 0.0),
		(   0.0, 5000.0, 0.0))
		);
	    FINISH_CREATING_SUBPICTURES(NS_RUNWAY_APPEARANCE);

	    ADD_POINTS(EW_RUNWAY_APPEARANCE,
		VECTOR_OF_POSITION'(
		(-300.0,    0.0, 0.0),
		( 300.0,    0.0, 0.0))
		);
	else
	    ADD_POINTS(NS_RUNWAY_APPEARANCE,
		VECTOR_OF_POSITION'(
		(  30.0, 5000.0, 0.0),
		( -30.0, 5000.0, 0.0),
		( -30.0, -250.0, 0.0),
		(  30.0, -250.0, 0.0),
		(  30.0, 5000.0, 0.0))
		);
	    FINISH_CREATING_SUBPICTURES(NS_RUNWAY_APPEARANCE);

	    ADD_POINTS(EW_RUNWAY_APPEARANCE,
		VECTOR_OF_POSITION'(
		(-300.0,   10.0, 0.0),
		(-300.0,  -10.0, 0.0),
		( 300.0,  -10.0, 0.0),
		( 300.0,   10.0, 0.0),
		(-300.0,   10.0, 0.0))
		);
	end if;

	if not SIMPLE_WORLD then
	    declare
		TOWER_POSITION : constant array(1..3) of OBJECTS.OBJECT_LOCATION
		    := (( 200.0,   13.3, 0.0),
			(  33.3,  -63.3, 0.0),
			(  33.3, 1050.0, 0.0));
	    begin
		for T in TOWER_POSITION'range loop
		    declare
			I	: constant METRES
			    := METRES(TOWER_POSITION(T).I);
			J	: constant METRES
			    := METRES(TOWER_POSITION(T).J);
		    begin
			ADD_SUBPICTURE(EW_RUNWAY_APPEARANCE,
			    FURTHEREST_VISIBLE => 10_000.0);
			ADD_POINTS(EW_RUNWAY_APPEARANCE,
			    VECTOR_OF_POSITION'(
			    (I-3.3, J-3.3,  27.0),    -- up to the roof, roof square
			    (I+3.3, J-3.3,  27.0),
			    (I+3.3, J+3.3,  27.0),
			    (I-3.3, J+3.3,  27.0),
			    (I-3.3, J-3.3,  27.0),
			    (I-3.3, J-3.3,   0.0))    -- back down to the base
			    );
			ADD_SUBPICTURE(EW_RUNWAY_APPEARANCE,
			    FURTHEREST_VISIBLE => 10_000.0);
			ADD_POINTS(EW_RUNWAY_APPEARANCE,
			    VECTOR_OF_POSITION'(
			    (I+3.3, J-3.3,  0.0),     -- next corner
			    (I+3.3, J-3.3, 27.0))
			    );
			ADD_SUBPICTURE(EW_RUNWAY_APPEARANCE,
			    FURTHEREST_VISIBLE => 10_000.0);
			ADD_POINTS(EW_RUNWAY_APPEARANCE,
			    VECTOR_OF_POSITION'(
			    (I+3.3, J+3.3,  0.0),	    -- next corner
			    (I+3.3, J+3.3, 27.0))
			    );
			ADD_SUBPICTURE(EW_RUNWAY_APPEARANCE,
			    FURTHEREST_VISIBLE => 10_000.0);
			ADD_POINTS(EW_RUNWAY_APPEARANCE,
			    VECTOR_OF_POSITION'(
			    (I-3.3,  J+3.3,  0.0),     -- next corner
			    (I-3.3,  J+3.3, 27.0))
			    );
		    end;
		end loop;
	    end;
	end if;

	FINISH_CREATING_SUBPICTURES(EW_RUNWAY_APPEARANCE);

    end;
end;
