--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    CONTROLS, INSTRUMENTS,
    BULLETS, MISSILE, MISSILE_GUIDANCE, SIGHT,
    INFO_MANAGER,
    MAIN_SIMULATION,
    LOGICAL_TO_BOOLEAN;

use
    INFO_MANAGER;

pragma ELABORATE(
    LOGICAL_TO_BOOLEAN);

package body WEAPONS is

    -- Bullets are really hacked, for now...
    --
    BULLET_BURST_FIRST_LENGTH	    : constant NATURAL := 10;
    BULLET_BURST_CONTINUES_LENGTH   : constant NATURAL :=  5;
    BULLET_BURST		    : NATURAL := 0;

    type GUN_TEMPERATURE_TYPE is digits 3;
    AMBIENT_GUN_TEMPERATURE : constant GUN_TEMPERATURE_TYPE :=   0.0;
    GUN_TEMPERATURE_INCREASE_PER_SECOND
			    : constant GUN_TEMPERATURE_TYPE :=  50.0;
    GUN_TEMPERATURE_DECREASE_PER_SECOND
			    : constant GUN_TEMPERATURE_TYPE :=  10.0;
    GUN_TEMPERATURE_MAXIMUM : constant GUN_TEMPERATURE_TYPE := 100.0;

    GUN_HAS_TEMPERATURE_LIMIT : constant BOOLEAN
			    := LOGICAL_TO_BOOLEAN(
				    "FCTM_GUN_HAS_TEMPERATURE_LIMIT", TRUE);
    GUN_FIRES_CONTINUOUSLY  : constant BOOLEAN
			    := LOGICAL_TO_BOOLEAN(
				    "FCTM_GUN_FIRES_CONTINUOUSLY", FALSE);


    type WEAPONS_STATUS_TYPE is
	record
	    MISSILE_COUNT   : NATURAL;
	    BULLET_COUNT    : NATURAL;
	    GUN_TEMPERATURE : GUN_TEMPERATURE_TYPE;
	end record;

    WEAPONS_INFO_INDEX	: WEAPON_INFO_TYPE := 0;
    WEAPONS_STATUSES	: array(WEAPON_INFO_TYPE) of WEAPONS_STATUS_TYPE;


    function ASSIGN return WEAPON_INFO_TYPE is
    begin
	WEAPONS_INFO_INDEX := WEAPONS_INFO_INDEX + 1;
	return WEAPONS_INFO_INDEX;
    end;


    procedure RELOAD(
	MISSILE_COUNT	    : in NATURAL;
	BULLET_COUNT	    : in NATURAL;
	CONTROLLED_OBJECT   : in out OBJECTS.OBJECT_TYPE) is
    begin
	if CONTROLLED_OBJECT.WEAPON_INFO = 0 then
	    CONTROLLED_OBJECT.WEAPON_INFO := ASSIGN;
	end if;
	declare
	    WI : WEAPONS_STATUS_TYPE renames
		    WEAPONS_STATUSES(CONTROLLED_OBJECT.WEAPON_INFO);
	begin
	    WI.BULLET_COUNT	:= BULLET_COUNT;
	    WI.MISSILE_COUNT	:= MISSILE_COUNT;
	    WI.GUN_TEMPERATURE	:= AMBIENT_GUN_TEMPERATURE;
	end;
    end;


    procedure OBEY_CONTROLS(
	CONTROL_SETTING 	: CONTROLS.CONTROL_SETTING_TYPE;
	ELAPSED_SINCE_LAST_MOVE	: SCALAR_PHYSICS.SECONDS;
	CONTROLLED_OBJECT	: in out OBJECTS.OBJECT_TYPE) is


	SIGNAL_STRENGTH     : MISSILE.SIGNAL_STRENGTH_TYPE := 0.0;
	TARGET		    : OBJECTS.ACCESS_OBJECT_TYPE;


    begin

	-- Weapons?
	--
	if CONTROLLED_OBJECT.WEAPON_INFO = 0 then return; end if;

	declare
	    WI : WEAPONS_STATUS_TYPE renames
		    WEAPONS_STATUSES(CONTROLLED_OBJECT.WEAPON_INFO);
	begin

	    -- Radar gunsight
	    --
	    SIGHT.SCAN(CONTROLLED_OBJECT);

	    -- Missiles
	    --
	    if WI.MISSILE_COUNT > 0 then

		-- Growl according to signal strength
		--
		MISSILE_GUIDANCE.GUIDE(
		    CONTROLLED_OBJECT, SIGNAL_STRENGTH, TARGET);

		-- Fire
		--
		if CONTROL_SETTING.TRIGGER1_PRESSED then
		    if OBJECTS."/="(TARGET, null) then
			WI.MISSILE_COUNT := WI.MISSILE_COUNT - 1;
			declare
			    M   : OBJECTS.ACCESS_OBJECT_TYPE
				:= OBJECTS.CREATE(OBJECTS.THIS_SIMULATOR,
					    OBJECTS.MISSILE,
					    0,
					    CONTROLLED_OBJECT.LOCATION,
					    CONTROLLED_OBJECT.ORIENTATION,
					    CONTROLLED_OBJECT.VELOCITY);
			begin
			    MAIN_SIMULATION.ADD_ONE_OBJECT(M);
			end;
		    end if;
		end if;
	    end if;

	    -- Gun
	    --
	    if WI.GUN_TEMPERATURE <= AMBIENT_GUN_TEMPERATURE then
		WI.GUN_TEMPERATURE := AMBIENT_GUN_TEMPERATURE;
	    else
		WI.GUN_TEMPERATURE := WI.GUN_TEMPERATURE -
		    GUN_TEMPERATURE_DECREASE_PER_SECOND *
		    GUN_TEMPERATURE_TYPE(ELAPSED_SINCE_LAST_MOVE);
	    end if;

	    if CONTROL_SETTING.TRIGGER2_PRESSED
	    or GUN_FIRES_CONTINUOUSLY
	    then
		if BULLET_BURST = 0 then
		    -- Probably first depression, go until autorepeat kicks in
		    BULLET_BURST := BULLET_BURST_FIRST_LENGTH;
		else
		    -- Probably Autorepeating, shorter so stops faster after
		    -- autorepeat stops
		    BULLET_BURST := BULLET_BURST_CONTINUES_LENGTH;
		end if;
	    end if;

	    if CONTROL_SETTING.TRIGGER2_RELEASED
	    then
		BULLET_BURST := BULLET_BURST_CONTINUES_LENGTH;
	    end if;

	    if WI.BULLET_COUNT <= 0 then
		BULLET_BURST := 0;

	    elsif BULLET_BURST > 0 then
		BULLET_BURST := BULLET_BURST - 1;

		WI.BULLET_COUNT := WI.BULLET_COUNT - 1;

		declare
		    B   : OBJECTS.ACCESS_OBJECT_TYPE
			:= OBJECTS.CREATE(OBJECTS.THIS_SIMULATOR,
				    OBJECTS.BULLETS,
				    0,
				    CONTROLLED_OBJECT.LOCATION,
				    CONTROLLED_OBJECT.ORIENTATION,
				    CONTROLLED_OBJECT.VELOCITY);
		begin
		    MAIN_SIMULATION.ADD_ONE_OBJECT(B);
		end;

		if GUN_HAS_TEMPERATURE_LIMIT then
		    WI.GUN_TEMPERATURE := WI.GUN_TEMPERATURE +
			GUN_TEMPERATURE_INCREASE_PER_SECOND *
			GUN_TEMPERATURE_TYPE(ELAPSED_SINCE_LAST_MOVE);

		    if WI.GUN_TEMPERATURE > GUN_TEMPERATURE_MAXIMUM then
			WI.BULLET_COUNT := 0;
		    end if;
		end if;

	    end if;

	    -- Set instruments
	    --
	    declare
		use INSTRUMENTS;
	    begin
		SET(INSTRUMENTS.MISSILE_GUIDANCE,
		    VALUE_TYPE(SIGNAL_STRENGTH)/
		    VALUE_TYPE(MISSILE_GUIDANCE.MAX_SIGNAL_STRENGTH));
	    end;
	end;
    end;


    procedure GET_COUNTS(
	CONTROLLED_OBJECT   : in OBJECTS.OBJECT_TYPE;
	MISSILE_COUNT	    : out NATURAL;
	BULLET_COUNT	    : out NATURAL) is
    begin
	if CONTROLLED_OBJECT.WEAPON_INFO = 0 then
	    MISSILE_COUNT := 0;
	    BULLET_COUNT  := 0;
	    return;
	end if;

	declare
	    WI : WEAPONS_STATUS_TYPE renames
		    WEAPONS_STATUSES(CONTROLLED_OBJECT.WEAPON_INFO);
	begin
	    MISSILE_COUNT := WI.MISSILE_COUNT;
	    BULLET_COUNT  := WI.BULLET_COUNT;
	end;
    end;


end;
