--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with GRAPHICS_WINDOW_MANAGER, LOGICAL_TO_FLOAT, SCREEN_MEASUREMENT_MIN;
use  GRAPHICS_WINDOW_MANAGER;

pragma ELABORATE(LOGICAL_TO_FLOAT);
pragma ELABORATE(SCREEN_MEASUREMENT_MIN);

package VIEW_WINDOW_MANAGER is

    GW		    : GRAPHICS_WINDOW_TYPE;

    WIDTH	    : constant SCREEN_MEASUREMENT :=
	SCREEN_MEASUREMENT(
	LOGICAL_TO_FLOAT("FCTM_VIEW_WINDOW_MANAGER_WIDTH", 94.0));

    HEIGHT	    : constant SCREEN_MEASUREMENT :=
	SCREEN_MEASUREMENT(
	LOGICAL_TO_FLOAT("FCTM_VIEW_WINDOW_MANAGER_HEIGHT", 65.0));

    INSTRUMENT_PANEL_HEIGHT : constant SCREEN_MEASUREMENT :=
	SCREEN_MEASUREMENT(
	LOGICAL_TO_FLOAT("FCTM_VIEW_WINDOW_MANAGER_IP_HEIGHT", 25.0));

    MIN_OF_WIDTH_AND_HEIGHT : constant SCREEN_MEASUREMENT
	:= SCREEN_MEASUREMENT_MIN(WIDTH, HEIGHT);

    WIDTH_MIDDLE    : constant SCREEN_MEASUREMENT
		    := WIDTH/2.0;

    HEIGHT_MIDDLE   : constant SCREEN_MEASUREMENT
		    := HEIGHT/2.0+INSTRUMENT_PANEL_HEIGHT;

end;
