--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with OBJECTS, SCALAR_PHYSICS, WORLD_PHYSICS, VIEW_DIRECTION_MANAGER;
package VIEW_MANAGER is

    -- We do this real hack in the right place to position the horizon
    -- in line with where the real horizon would be, but at this distance
    -- from the viewer...
    --
    -- A shadow is placed under the OBJECT_VIEWED_FROM,
    -- and orientation marks are placed around the OBJECT_VIEWED_FROM
    --
    HORIZON_DISTANCE	    : constant SCALAR_PHYSICS.METRES := 1.0E5;
    HORIZON		    : OBJECTS.ACCESS_OBJECT_TYPE;
    SHADOW		    : OBJECTS.ACCESS_OBJECT_TYPE;
    ORIENTATION_MARKS	    : OBJECTS.ACCESS_OBJECT_TYPE;

    -- Misc read-write information about the object being viewed from
    --
    OBJECT_VIEWED_FROM	    : OBJECTS.ACCESS_OBJECT_TYPE;
    VIEW_DIRECTION	    : VIEW_DIRECTION_MANAGER.VIEW_DIRECTION_TYPE
			    := VIEW_DIRECTION_MANAGER.DEFAULT_VIEW_DIRECTION;

    -- Misc read-only information about the object viewed from
    --
    package VIEW_POINT_READ_ONLY is
	ORIGIN		    : OBJECTS.OBJECT_LOCATION;
	ORIENTATION 	    : WORLD_PHYSICS.POSITION_BASIS;
    end;

    -- Viewpoint
    --
    OLD_OBJECT_VIEWED_FROM  : OBJECTS.ACCESS_OBJECT_TYPE
			    := null;
    OLD_VIEW_DIRECTION	    : VIEW_DIRECTION_MANAGER.VIEW_DIRECTION_TYPE
			    := VIEW_DIRECTION_MANAGER.DEFAULT_VIEW_DIRECTION;

    -- Procedure to set the viewpoint
    --
    procedure UPDATE_VIEWPOINT;

    
end;
