--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with SCALAR_PHYSICS, OBJECT_PHYSICS;

package body VIEW_MANAGER is
    use OBJECTS, VIEW_DIRECTION_MANAGER, VIEW_POINT_READ_ONLY;

    procedure UPDATE_VIEWPOINT is
    begin

	if OBJECT_VIEWED_FROM /= OLD_OBJECT_VIEWED_FROM
	or VIEW_DIRECTION /= OLD_VIEW_DIRECTION
	then
	    -- Change the variables
	    --
	    OLD_OBJECT_VIEWED_FROM := OBJECT_VIEWED_FROM;
	    OLD_VIEW_DIRECTION     := VIEW_DIRECTION;

	end if;

	if OBJECT_VIEWED_FROM = null then
	    return;
	end if;

	declare
	    use WORLD_PHYSICS;

	    O : OBJECT_TYPE renames OBJECT_VIEWED_FROM.all;

	    function HUNDREDS(M : OBJECT_LOCATION_COORDINATE)
		return OBJECT_LOCATION_COORDINATE is

		K   : constant INTEGER
		    := INTEGER(100.0/OBJECT_LOCATION_COORDINATE'small);

	    begin
		return (M/K)*K;
	    end;

	begin

	    -- ORIGIN := O.LOCATION + O.VIEW_LOCATION;

	    declare
		use SCALAR_PHYSICS;
		OP   : OBJECT_PHYSICS.POSITION renames O.VIEW_LOCATION;
		OP_I : constant SCALE_TYPE := SCALE_TYPE(OP.I);
		OP_J : constant SCALE_TYPE := SCALE_TYPE(OP.J);
		OP_K : constant SCALE_TYPE := SCALE_TYPE(OP.K);
	    begin

		ORIGIN.I :=
		    OBJECT_LOCATION_COORDINATE(
			O.ORIENTATION.I.I*OP_I + 
			O.ORIENTATION.J.I*OP_J + 
			O.ORIENTATION.K.I*OP_K) +
		    O.LOCATION.I;

		ORIGIN.J :=
		    OBJECT_LOCATION_COORDINATE(
			O.ORIENTATION.I.J*OP_I + 
			O.ORIENTATION.J.J*OP_J + 
			O.ORIENTATION.K.J*OP_K) +
		    O.LOCATION.J;

		ORIGIN.K :=
		    OBJECT_LOCATION_COORDINATE(
			O.ORIENTATION.I.K*OP_I + 
			O.ORIENTATION.J.K*OP_J + 
			O.ORIENTATION.K.K*OP_K) +
		    O.LOCATION.K;

	    end;

	    -- this tricky piece of math places the horizon object in
	    -- line with where the real horizon is, but closer to fool/help
	    -- the 3d-2d projection code which can't cope with the real
	    -- distances that result...
	    --
	    HORIZON.LOCATION.I := O.LOCATION.I;
	    HORIZON.LOCATION.J := O.LOCATION.J;
	    declare
		use SCALAR_PHYSICS;
		HI		: constant SCALE_TYPE := 5.0E4;
		SLOPE_AT_HI     : constant SCALE_TYPE := 13.0;
		DISTANCE_AT_ONE : constant SCALE_TYPE := 3100.0;
	    begin
		HORIZON.LOCATION.K :=
		    O.LOCATION.K -
			OBJECT_LOCATION_COORDINATE(
			    SCALE_TYPE(HORIZON_DISTANCE)/
			    (SLOPE_AT_HI +
			     (DISTANCE_AT_ONE/HI)*
			     (HI-SCALE_TYPE(O.LOCATION.K))
			    ));
	    end;

	    -- The shadow is place on a grid underneath the viewer
	    --
	    SHADOW.LOCATION.I := HUNDREDS(O.LOCATION.I);
	    SHADOW.LOCATION.J := HUNDREDS(O.LOCATION.J);
	    SHADOW.LOCATION.K := 0.0;

	    -- Set the orientation marks
	    --
	    if ORIENTATION_MARKS /= null then
		ORIENTATION_MARKS.LOCATION	:= O.LOCATION;
		ORIENTATION_MARKS.ORIENTATION	:= O.ORIENTATION;
	    end if;

	    -- Set the viewing direction
	    --
	    ORIENTATION := VIEW_ORIENTATION(VIEW_DIRECTION, O.ORIENTATION);
	end;
    end;

begin
    ORIGIN	:= (0.0, -7000.0, 900.0);
    ORIENTATION := WORLD_PHYSICS.USUAL_POSITION_BASIS;
end;
