--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with TRIG, SCALE_TYPE_TRIG, SCALAR_PHYSICS, WORLD_PHYSICS,
     VIEW_DIRECTION_MANAGER, VIEW_DIRECTION_CONTROL,
     TEXT_IO, FLOAT_TEXT_IO;

use  TRIG, SCALE_TYPE_TRIG, SCALAR_PHYSICS, WORLD_PHYSICS,
     VIEW_DIRECTION_MANAGER, VIEW_DIRECTION_CONTROL,
     TEXT_IO, FLOAT_TEXT_IO;

procedure VIEW_DIRECTION_MANAGER_TEST is
    V	: VIEW_DIRECTION_TYPE := DEFAULT_VIEW_DIRECTION;
    O	: WORLD_PHYSICS.POSITION_BASIS;

    R1	: RADIANS;
    R2	: RADIANS;

begin
    SWIVEL(V, CONTROL_TYPE'(TO_ARBITRARY,1.0,0.0), 0.05);
    for I in 1..100 loop
	O := VIEW_ORIENTATION(V,USUAL_POSITION_BASIS);
	FLOAT_TEXT_IO.PUT(FLOAT(I)*0.05);
	TEXT_IO.PUT(' ');
	FLOAT_TEXT_IO.PUT(FLOAT(O.J.I));
	TEXT_IO.PUT(' ');
	FLOAT_TEXT_IO.PUT(FLOAT(O.J.J));
	TEXT_IO.PUT(' ');

	R1 := ACOS(SCALE_TYPE(O.J.J));
	FLOAT_TEXT_IO.PUT(FLOAT(R1));

	TEXT_IO.PUT("Rate => ");
	FLOAT_TEXT_IO.PUT(
	    FLOAT(360.0)*FLOAT(R2-R1)/FLOAT'(0.05*RADIANS_PER_CIRCLE)
	    );
	R2 := R1;

	TEXT_IO.NEW_LINE;
	SWIVEL(V, CONTROL_TYPE'(CONTROL_STATE=>UNCHANGED), 0.05);
    end loop;
end;
