--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    VIEW_DIRECTION_CONTROL,
    TRIG, SCALAR_PHYSICS, WORLD_PHYSICS, OBJECT_PHYSICS, LOGICAL_TO_BOOLEAN;

pragma ELABORATE(
    VIEW_DIRECTION_CONTROL,
    TRIG, SCALAR_PHYSICS, WORLD_PHYSICS, OBJECT_PHYSICS, LOGICAL_TO_BOOLEAN);

package VIEW_DIRECTION_MANAGER is
    use VIEW_DIRECTION_CONTROL;

    type VIEW_DIRECTION_TYPE is private;

    DEFAULT_VIEW_DIRECTION : constant VIEW_DIRECTION_TYPE;

    function VIEW_ORIENTATION(
	VIEW_DIRECTION	    : VIEW_DIRECTION_TYPE;
	RELATIVE_TO	    : WORLD_PHYSICS.POSITION_BASIS)
	return WORLD_PHYSICS.POSITION_BASIS;

    -- Controls to change VIEW_DIRECTION_TYPE
    --
    procedure SWIVEL(
	VIEW_DIRECTION	    : in out VIEW_DIRECTION_TYPE;
	CONTROL 	    : CONTROL_TYPE;
	ELAPSED_TIME	    : SCALAR_PHYSICS.SECONDS := 0.0);

private
    type DIRECTION_INDEX_TYPE is new NATURAL;

    type REAL_VIEW_DIRECTION_TYPE(SMOOTH : BOOLEAN := FALSE) is
	record
	    case SMOOTH is
		when FALSE =>
		    DIRECTION_INDEX : DIRECTION_INDEX_TYPE;
		when TRUE  =>
		    ELAPSED_TIME    : SCALAR_PHYSICS.SECONDS;
		    CONTROL	    : CONTROL_TYPE;
		    ANGLE_RIGHT_OFF_J,
		    ANGLE_UP_OFF_J  : TRIG.RADIANS;
		    ORIENTATION     : OBJECT_PHYSICS.POSITION_BASIS;
	    end case;
	end record;

    DEFAULT_REAL_VIEW_DIRECTIONS : constant array(BOOLEAN) of
	REAL_VIEW_DIRECTION_TYPE :=
	    (FALSE => (SMOOTH => FALSE, DIRECTION_INDEX => 0),
	     TRUE  => (SMOOTH => TRUE,
			ELAPSED_TIME	=> 0.0,
			CONTROL 	=> (CONTROL_STATE => STOP),
			ANGLE_RIGHT_OFF_J|
			ANGLE_UP_OFF_J	=> 0.0,
			ORIENTATION	=> OBJECT_PHYSICS.USUAL_POSITION_BASIS)
	    );

    VIEW_SMOOTH : constant BOOLEAN
	:= LOGICAL_TO_BOOLEAN("FCTM_VIEW_SMOOTH", TRUE);

    type VIEW_DIRECTION_TYPE is
	new REAL_VIEW_DIRECTION_TYPE(VIEW_SMOOTH);

    DEFAULT_VIEW_DIRECTION : constant VIEW_DIRECTION_TYPE
	:= VIEW_DIRECTION_TYPE(DEFAULT_REAL_VIEW_DIRECTIONS(VIEW_SMOOTH));

end;
