--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


package VIEW_DIRECTION_CONTROL is

    type SWIVEL_RATE_TYPE is digits 3 range -1.0 .. 1.0;

    type CONTROL_STATE_TYPE is (UNCHANGED, STOP, TO_FRONT, TO_ARBITRARY);

    type CONTROL_TYPE(CONTROL_STATE : CONTROL_STATE_TYPE := UNCHANGED)
    is
	record
	    case CONTROL_STATE is
		when UNCHANGED =>
		    null;
		when STOP =>
		    null;
		when TO_FRONT =>
		    null;
		when TO_ARBITRARY =>
		    SWIVEL_RIGHT_LEFT   : SWIVEL_RATE_TYPE;
		    SWIVEL_UP_DOWN	: SWIVEL_RATE_TYPE;
	    end case;
	end record;

end;
