--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with SCALAR_PHYSICS, OBJECT_PHYSICS, TRIG, INFO_MANAGER,
    OBJECTS,
    AEROPLANE_ENGINES;
use  SCALAR_PHYSICS,
    AEROPLANE_ENGINES;
pragma ELABORATE(
    SCALAR_PHYSICS,
    OBJECTS,
    AEROPLANE_ENGINES);

package VARIOUS_AEROPLANES_DATA is


    subtype AEROFOIL_NAME_LENGTH_RANGE is NATURAL range 0..24;
    type AEROFOIL_NAME_TYPE(LENGTH : AEROFOIL_NAME_LENGTH_RANGE := 0) is
	record
	    NAME : STRING(1..LENGTH);
	end record;


    type DEGREES is digits 3 range -180.0 .. 180.0;

    type LIFT_DEVICES_TYPE is (N, F, FS);   -- None, Flaps, Flaps and Slats

    type PLANE_DATA_TYPE is
	record
	    NAME		: STRING(1..6);
	    APPEARANCE_INFO	: INFO_MANAGER.APPEARANCE_INFO_TYPE;
	    VIEW_LOCATION	: OBJECT_PHYSICS.POSITION;

	    AEROFOIL_NAME	: AEROFOIL_NAME_TYPE;
	    EXTRA_ZERO_DRAG	: SCALE_TYPE;		-- for adding strings/wheels/etc
	    SPAN		: METRES;
	    WING_AREA		: METRES_SQUARED;
	    ASPECT_RATIO	: SCALE_TYPE;
	    TAPER_RATIO 	: SCALE_TYPE;
	    DIHEDRAL		: DEGREES;
	    WING_PLACEMENT	: DEGREES;		-- from CG to wing CL
	    SWEEPBACK_LEAD	: DEGREES;
	    THICKNESS_INNER,
	    THICKNESS_OUTER	: SCALE_TYPE;
	    WING_LOADING	: NEWTONS_PER_METRE_SQUARED;
	    LIFT_DEVICES	: LIFT_DEVICES_TYPE;
	    IH_PER_C		: SCALE_TYPE;
	    SH_PER_S,
	    SHN_PER_S		: SCALE_TYPE;
	    VH,
	    VHN 		: SCALE_TYPE;
	    IV_PER_S		: SCALE_TYPE;
	    SV_PER_S		: SCALE_TYPE;
	    Vv			: SCALE_TYPE;

	    -- From page 127
	    --
	    ENGINE_COUNT	: POSITIVE;
	    ENGINE		: ENGINE_HANDLE_TYPE;

	    -- misc added by me
	    --
	    POSITIVE_G_LIMIT,
	    NEGATIVE_G_LIMIT	: SCALE_TYPE;

	    RADIUS		: METRES;
	    EXTRA_RADII 	: OBJECTS.VECTOR_OF_EXTRA_RADIUS_TYPE(1..5);

	    CAS_FLAP_LIMIT	: METRES_PER_SECOND;
	    FLAP_G_LIMIT	: SCALE_TYPE;

	    CAS_AEROLON_LIMIT	    : METRES_PER_SECOND;
	    AEROLON_PER_WING_AREA   : SCALE_TYPE range 0.0 .. 1.0;
	    MAX_ELEVATOR_DEFLECTION : TRIG.RADIANS;
	    CAS_PITCH_LIMIT	    : METRES_PER_SECOND;
	    ROTATE_SPEED	    : METRES_PER_SECOND;

	    MAX_FUEL_MASS	: KILOGRAMS;
	end record;

    type VECTOR_OF_PLANE_DATA_TYPE is
	array(POSITIVE range <>) of PLANE_DATA_TYPE;

    type ACCESS_VECTOR_OF_PLANE_DATA_TYPE is access VECTOR_OF_PLANE_DATA_TYPE;


    function PLANE_DATA return ACCESS_VECTOR_OF_PLANE_DATA_TYPE;

end;
