--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


package TRIG is

    -- Usual definitions
    --
    PI			    : constant	:= 3.141592653589793;
    RADIANS_PER_CIRCLE	    : constant	:= 2.0*PI;
    RADIANS_PER_RIGHT_ANGLE : constant	:= PI/2.0;

    type RADIANS is digits 4;	-- enough to resolve 1000 pixels in 120 degrees

    -- Simple trig. functions
    --
    generic
	type SOME_FLOAT is digits <>;
    package TRIG_FUNCTIONS is
	function "*"(LEFT : SOME_FLOAT; RIGHT : RADIANS) return RADIANS;
	function "*"(LEFT : RADIANS; RIGHT : SOME_FLOAT) return RADIANS;
	function "/"(LEFT : RADIANS; RIGHT : SOME_FLOAT) return RADIANS;
	function SIN(R : RADIANS) return SOME_FLOAT;
	function COS(R : RADIANS) return SOME_FLOAT;
	function TAN(R : RADIANS) return SOME_FLOAT;
	function ASIN_ACOS(SIN,COS : SOME_FLOAT) return RADIANS;
	function ASIN(SIN : SOME_FLOAT) return RADIANS;
	function ACOS(COS : SOME_FLOAT) return RADIANS;
--	function ATAN(TAN : SOME_FLOAT) return RADIANS;
    private
	pragma INLINE ("*", "/", SIN, COS, TAN, ASIN, ACOS, ASIN_ACOS);
--	pragma INLINE (ATAN);
    end;
	pragma INLINE_GENERIC(TRIG_FUNCTIONS);

end;

