--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with SCALAR_PHYSICS;

with DISTANCE_VECTOR_MANAGER;
with VELOCITY_VECTOR_MANAGER;
with ACCELERATION_VECTOR_MANAGER;

generic
package THREE_DIMENSIONAL_PHYSICS is

    subtype SECONDS is SCALAR_PHYSICS.SECONDS;

    type POSITION	is new DISTANCE_VECTOR_MANAGER.VECTOR;
    type VELOCITY	is new VELOCITY_VECTOR_MANAGER.VECTOR;
    type ACCELERATION	is new ACCELERATION_VECTOR_MANAGER.VECTOR;

    subtype UNIT_POSITION	is POSITION;
    subtype UNIT_VELOCITY	is VELOCITY;
    subtype UNIT_ACCELERATION	is ACCELERATION;

    type POSITION_BASIS is
	record
	    I, J, K : UNIT_POSITION;
	end record;

    USUAL_POSITION_BASIS : constant POSITION_BASIS :=
	((1.0, 0.0, 0.0), (0.0, 1.0, 0.0), (0.0, 0.0, 1.0));

    type VELOCITY_BASIS is
	record
	    I, J, K : UNIT_VELOCITY;
	end record;

    USUAL_VELOCITY_BASIS : constant VELOCITY_BASIS :=
	((1.0, 0.0, 0.0), (0.0, 1.0, 0.0), (0.0, 0.0, 1.0));

    type ACCELERATION_BASIS is
	record
	    I, J, K : UNIT_ACCELERATION;
	end record;

    USUAL_ACCELERATION_BASIS : constant ACCELERATION_BASIS :=
	((1.0, 0.0, 0.0), (0.0, 1.0, 0.0), (0.0, 0.0, 1.0));

    function "*"(V : VELOCITY;	    S : SECONDS) return POSITION;
    function "*"(A : ACCELERATION;  S : SECONDS) return VELOCITY;

    function "/"(P : POSITION;	    S : SECONDS) return VELOCITY;
    function "/"(V : VELOCITY;	    S : SECONDS) return ACCELERATION;

private
    pragma INLINE("*");
    pragma INLINE("/");
end;
