--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


package body THREE_DIMENSIONAL_PHYSICS is

    use SCALAR_PHYSICS;

    function "*"(V : VELOCITY;	    S : SECONDS) return POSITION is
    begin
	return (V.I*S, V.J*S, V.K*S);
    end;

    function "*"(A : ACCELERATION;  S : SECONDS) return VELOCITY is
    begin
	return (A.I*S, A.J*S, A.K*S);
    end;

    function "/"(P : POSITION;	    S : SECONDS) return VELOCITY is
    begin
	return (P.I/S, P.J/S, P.K/S);
    end;

    function "/"(V : VELOCITY;	    S : SECONDS) return ACCELERATION is
    begin
	return (V.I/S, V.J/S, V.K/S);
    end;

end;
