--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with SYSTEM, TEXT_IO;
package SYSTEM_INTERFACE is

    type ADDRESS is new SYSTEM.ADDRESS;
    ADDRESS_ZERO : constant ADDRESS := ADDRESS(SYSTEM.ADDRESS_ZERO);

    type UNSIGNED_BYTE is range 0..255; for UNSIGNED_BYTE'size use 8;
    type UNSIGNED_BYTE_ARRAY is array(POSITIVE range <>) of UNSIGNED_BYTE;
	pragma PACK(UNSIGNED_BYTE_ARRAY);

    type FAST_FLOAT is digits 6;
    type LONGEST_FLOAT is digits SYSTEM.MAX_DIGITS;

    package FAST_FLOAT_TEXT_IO is new TEXT_IO.FLOAT_IO(FAST_FLOAT);
    package LONGEST_FLOAT_TEXT_IO is new TEXT_IO.FLOAT_IO(LONGEST_FLOAT);

    generic
	type SOME_FLOAT is digits <>;
    function DIGITS_SQRT(A : SOME_FLOAT) return SOME_FLOAT;
	pragma INLINE_GENERIC(DIGITS_SQRT);
	pragma INLINE(DIGITS_SQRT);

    function GET_CPU_TIME return DURATION;

    function RANDOM return FLOAT;

    function SIN (X : FAST_FLOAT) return FAST_FLOAT;
    function ASIN(X : FAST_FLOAT) return FAST_FLOAT;

    function ALLOCATE_MEMORY(NUMBER_OF_BYTES : POSITIVE) return ADDRESS;

end;
