--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    UNCHECKED_DEALLOCATION;

pragma ELABORATE(
    UNCHECKED_DEALLOCATION);

package body SUBCLASS_INFO_GENERIC_PKG is

    procedure CREATE_SUBCLASS_INFO(O : in out OBJECTS.OBJECT_TYPE) is
    begin
	if O.SUBCLASS_INFO = 0 then
	    O.SUBCLASS_INFO := ASSIGN;
	    SUBCLASS_INFO_TO_ACCESS_STATUS(O.SUBCLASS_INFO) :=
		new STATUS_TYPE;
	    SUBCLASS_INFO_TO_ACCESS_STATUS(O.SUBCLASS_INFO).all :=
		SUBCLASS_INFO_TO_ACCESS_STATUS(
		    DEFAULT_SUBCLASS_INFO).all;
	end if;
    end;

    procedure DELETE_SUBCLASS_INFO(O  : in out OBJECTS.OBJECT_TYPE) is

	procedure DEALLOCATE is
	    new UNCHECKED_DEALLOCATION(
		    STATUS_TYPE, ACCESS_STATUS_TYPE);

    begin
	if O.SUBCLASS_INFO /= 0 then
	    DEALLOCATE(SUBCLASS_INFO_TO_ACCESS_STATUS(O.SUBCLASS_INFO));
	    DEASSIGN(O.SUBCLASS_INFO);
	end if;
    end;

begin
    SUBCLASS_INFO_TO_ACCESS_STATUS(DEFAULT_SUBCLASS_INFO) := new STATUS_TYPE;
end;
