--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with SCALAR_PHYSICS;
use  SCALAR_PHYSICS;
package STANDARD_ATMOSPHERE is

    type MACH_TYPE is digits 4;

    subtype ALTITUDE is METRES range 0.0 .. 100_000.0;

    function TO_DENSITY(H : ALTITUDE) return KILOGRAMS_PER_METRE_CUBED;
    function TO_MACH(V : METRES_PER_SECOND; H : ALTITUDE) return MACH_TYPE;
    function TO_TEMPERATURE(H : ALTITUDE) return KELVIN;

    function TO_SQRT_DENSITY_RATIO(H : ALTITUDE) return SCALE_TYPE;

end;
