--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    LOGICAL_TO_FLOAT,
    PHYSICAL_UNITS, SCALAR_PHYSICS, WORLD_PHYSICS, OBJECTS,
    APPEARANCE_MANAGER, INFO_MANAGER, BULLETS, MAIN_SIMULATION;

use 
    SCALAR_PHYSICS, WORLD_PHYSICS, OBJECTS,
    MAIN_SIMULATION;

pragma ELABORATE(
    LOGICAL_TO_FLOAT,
    PHYSICAL_UNITS, SCALAR_PHYSICS, WORLD_PHYSICS, OBJECTS,
    APPEARANCE_MANAGER, INFO_MANAGER, BULLETS, MAIN_SIMULATION);

package body SIGHT is

    subtype SECONDS is SCALAR_PHYSICS.SECONDS;

    -- General parameters
    --
    COS_SEARCH_ANGLE : constant SCALE_TYPE := 0.88;

    MAXIMUM_DISTANCE : constant METRES
	:= 1300.0;

    SIGHT_OBJECT : constant OBJECTS.ACCESS_OBJECT_TYPE
	:= CREATE(NONE_NEEDED, GROUND, 0,
		LOCATION    => (0.0, 0.0, 0.0), 
		ORIENTATION => USUAL_POSITION_BASIS,
		VELOCITY    => (0.0, 0.0, 0.0)
		);

    -- Current status
    --
    PREVIOUS_ORIENTATION_J  : WORLD_PHYSICS.POSITION;
    PREVIOUS_BEST_DISTANCE  : METRES;

    package SMOOTHED_DELTA_J is
	I,J,K : METRES := 0.0;
    end;


    procedure DEACQUIRE is
    begin
	ACQUIRED_SIGHT_OBJECT := null;
    end;


    procedure SCAN(
	GUN_CARRIER	    : in OBJECTS.OBJECT_TYPE) is

	use OBJECTS;

	GC : OBJECT_TYPE renames GUN_CARRIER;

	ACCESS_TARGET	    : ACCESS_OBJECT_TYPE;
	BEST_TARGET	    : ACCESS_OBJECT_TYPE    := null;
	BEST_DISTANCE	    : METRES;

    begin

	-- for all possible targets
	--
	for I in THIS_SIMULATOR..ANOTHER_SIMULATOR loop
	    ACCESS_TARGET := MAINTAINER_TO_ACCESS_OBJECT(I);
	    while ACCESS_TARGET /= null loop
		declare
		    TARGET : OBJECT_TYPE renames ACCESS_TARGET.all;
		begin
		    exit when TARGET.CLASS not in TARGET_CLASS_SUBTYPE;
		    if TARGET.SEQUENCE_NUMBER /= GUN_CARRIER.SEQUENCE_NUMBER
		    then

declare
    GC_TO_TARGET    : constant WORLD_PHYSICS.POSITION
	:= (METRES(TARGET.LOCATION.I-GC.LOCATION.I),
	    METRES(TARGET.LOCATION.J-GC.LOCATION.J),
	    METRES(TARGET.LOCATION.K-GC.LOCATION.K));

    DISTANCE	    : constant METRES
	:= LENGTH(GC_TO_TARGET);

    J_DISTANCE	    : constant METRES
	:= "&"(GC_TO_TARGET, GC.ORIENTATION.J);

begin
    -- if visible
    --
    if J_DISTANCE > DISTANCE*COS_SEARCH_ANGLE then
	if BEST_TARGET = null or else DISTANCE < BEST_DISTANCE then
	    BEST_TARGET     := ACCESS_TARGET;
	    BEST_DISTANCE   := DISTANCE;
	end if;
    end if;
end;

		    end if;
		    ACCESS_TARGET := TARGET.NEXT;
		end;
	    end loop;   -- scanning targets, inner
	end loop;   -- scanning targets

	-- Any?
	--
	if BEST_TARGET = null
	or else BEST_DISTANCE > MAXIMUM_DISTANCE
	then
	    DEACQUIRE;
	    return;
	end if;

	-- Try to compute and show lead, but needs two consecutive readings to
	-- do this.
	--
	if ACQUIRED_SIGHT_OBJECT /= null then

	    -- Average the best distance to smooth the sight a little
	    --
	    BEST_DISTANCE := (BEST_DISTANCE + PREVIOUS_BEST_DISTANCE)*
				SCALE_TYPE'(0.5);

	    -- Figure out where the sight should be
	    --
	    declare
		FLIGHT_TIME	    : constant SECONDS
		    := BULLETS.FLIGHT_TIME(BEST_DISTANCE);
		T		    : constant SECONDS
		    := MAIN_SIMULATION.ELAPSED_SINCE_LAST_ITERATION;

		package NEW_SIGHT_POSITION is
		    I,J,K : METRES;
		end;

	    begin
		-- Compute and Smooth the change in GC.ORIENTATION.J
		--
		declare
		    use SMOOTHED_DELTA_J;
		begin
		    I := ((GC.ORIENTATION.J.I - PREVIOUS_ORIENTATION_J.I)
			    +I)*SCALE_TYPE'(0.5);
		    J := ((GC.ORIENTATION.J.J - PREVIOUS_ORIENTATION_J.J)
			    +J)*SCALE_TYPE'(0.5);
		    K := ((GC.ORIENTATION.J.K - PREVIOUS_ORIENTATION_J.K)
			    +K)*SCALE_TYPE'(0.5);
		end;

		-- Bias the sight's position from the target's position,
		-- to give the place where the target should have been to hit it
		-- at the current range and delta j.
		--
		declare
		    S : constant SCALE_TYPE
			:=  SCALE_TYPE(BEST_DISTANCE)*
			    (SCALE_TYPE(FLIGHT_TIME)/SCALE_TYPE(T));
		begin
		    NEW_SIGHT_POSITION.I :=
			GC.ORIENTATION.J.I*SCALE_TYPE(BEST_DISTANCE) -
			SMOOTHED_DELTA_J.I*S;

		    NEW_SIGHT_POSITION.J :=
			GC.ORIENTATION.J.J*SCALE_TYPE(BEST_DISTANCE) -
			SMOOTHED_DELTA_J.J*S;

		    NEW_SIGHT_POSITION.K :=
			GC.ORIENTATION.J.K*SCALE_TYPE(BEST_DISTANCE) -
			SMOOTHED_DELTA_J.K*S -
			-- including gravity's effect on the bullets
			METRES( SCALE_TYPE'(0.5)*
			    SCALE_TYPE(PHYSICAL_UNITS.G)*
			    SCALE_TYPE(FLIGHT_TIME)**2 );
		end;

		-- Place the sight
		--
		SIGHT_OBJECT.LOCATION.I :=
		    GC.LOCATION.I +
		    OBJECT_LOCATION_COORDINATE(NEW_SIGHT_POSITION.I);

		SIGHT_OBJECT.LOCATION.J  :=
		    GC.LOCATION.J +
		    OBJECT_LOCATION_COORDINATE(NEW_SIGHT_POSITION.J);
		SIGHT_OBJECT.LOCATION.K  :=
		    GC.LOCATION.K +
		    OBJECT_LOCATION_COORDINATE(NEW_SIGHT_POSITION.K);

		SIGHT_OBJECT.ORIENTATION := GC.ORIENTATION;

	    end;
	end if;

	-- Note are tracking, and remember info for next time
	--
	ACQUIRED_SIGHT_OBJECT  := SIGHT_OBJECT;
	PREVIOUS_ORIENTATION_J := GC.ORIENTATION.J;
	PREVIOUS_BEST_DISTANCE := BEST_DISTANCE;
    end;

begin
    declare
	use APPEARANCE_MANAGER;
	AI : constant INFO_MANAGER.APPEARANCE_INFO_TYPE := CREATE;
	A  : constant ACCESS_APPEARANCE_TYPE := TO_ACCESS_APPEARANCE_TYPE(AI);
	D  : constant METRES := 0.0;
	L  : constant METRES := 2.5;
	W  : constant METRES := 5.0;
    begin
	SIGHT_OBJECT.APPEARANCE_INFO := AI;
	ADD_POINTS(A,
	    VECTOR_OF_POSITION'(
		(-L-W,D,0.0),
		(-L  ,D,0.0))
	    );
	ADD_SUBPICTURE(A);
	ADD_POINTS(A,
	    VECTOR_OF_POSITION'(
		( L  ,D,0.0),
		( L+W,D,0.0))
	    );
	FINISH_CREATING_SUBPICTURES(A);
    end;

end; pragma SUPPRESS_ALL;
