--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    SCALAR_PHYSICS, WORLD_PHYSICS, OBJECT_PHYSICS, TRIG, SCALE_TYPE_TRIG,
    RANDOM, MOVE_UTILITIES, MENU_MANAGER, OBJECTS;

pragma ELABORATE(
    SCALAR_PHYSICS, WORLD_PHYSICS, OBJECT_PHYSICS, TRIG, SCALE_TYPE_TRIG,
    RANDOM, MOVE_UTILITIES, MENU_MANAGER, OBJECTS);

package body SELECT_CRAFT is
    use OBJECTS, WORLD_PHYSICS, SCALAR_PHYSICS;


    type ENTRY_CLASS_TYPE is
	(EXACT, RANDOMIZE);

    type ENTRY_TYPE is
	record
	    ENTRY_CLASS : ENTRY_CLASS_TYPE;
	    NAME	: STRING(1..40);
	    LOCATION	: OBJECTS.OBJECT_LOCATION;
	    ORIENTATION : WORLD_PHYSICS.POSITION_BASIS;
	end record;

    type VECTOR_OF_CLASS_TYPE is array(POSITIVE range <>) of CLASS_TYPE;
    type VECTOR_OF_ENTRY_TYPE is array(POSITIVE range <>) of ENTRY_TYPE;

    SUPPORTED_CLASSES	: constant VECTOR_OF_CLASS_TYPE
			:=  (OBJECTS.AEROPLANE, OBJECTS.MAGIC_CARPET);

    CLASS_TO_SUBCLASS_PROVIDED : array(OBJECTS.CLASS_TYPE) of BOOLEAN
			:= (others => FALSE);

    SUBCLASS_MENU	: array(OBJECTS.CLASS_TYPE) of MENU_MANAGER.MENU_TYPE;

    SUPPORTED_ENTRIES	: constant VECTOR_OF_ENTRY_TYPE
			:=  (6=>(RANDOMIZE,
				 "Random. 30,000 ft+                      ",
			         (0.0, 15_000.0, 10_000.0),
			         USUAL_POSITION_BASIS),
			     5=>(EXACT,
				 "South end, heading North                ",
			         (0.0, -250.0, 0.0),
			         USUAL_POSITION_BASIS),
			     4=>(EXACT,
				 "North end, heading South                ",
			         (0.0, 5_000.0, 0.0),
			         (-USUAL_POSITION_BASIS.I,
				  -USUAL_POSITION_BASIS.J,
				   USUAL_POSITION_BASIS.K)),
			     3=>(EXACT,
				 "Landing practice                        ",
			         (800.0, -10_000.0, 1_300.0),
			         USUAL_POSITION_BASIS),
			     2=>(EXACT,
				 "10 miles north. 30,000 ft+              ",
				 (-600.0,  15_000.0, 10_000.0),
				 (-USUAL_POSITION_BASIS.I,
				  -USUAL_POSITION_BASIS.J,
				   USUAL_POSITION_BASIS.K)),
			     1=>(EXACT,
				 "10 miles south. 30,000 ft+              ",
				 (-600.0, -15_000.0, 10_000.0),
				 USUAL_POSITION_BASIS)
			    );

    ENTRY_MENU		: MENU_MANAGER.MENU_TYPE;
    CLASS_MENU		: MENU_MANAGER.MENU_TYPE;


    procedure PROVIDE_CLASS_TO_SUBCLASS_MENU(
	CLASS		: OBJECTS.CLASS_TYPE;
	MENU		: MENU_MANAGER.MENU_TYPE
	)
    is
    begin
	CLASS_TO_SUBCLASS_PROVIDED(CLASS) := TRUE;
	SUBCLASS_MENU(CLASS) := MENU;
    end;


    procedure CHOOSE(
	CLASS		: out OBJECTS.CLASS_TYPE;
	SUBCLASS_KEY	: out INTEGER;
	LOCATION	: out OBJECTS.OBJECT_LOCATION;
	ORIENTATION	: out WORLD_PHYSICS.POSITION_BASIS;
	VELOCITY	: out WORLD_PHYSICS.VELOCITY;

	ENTRY_CHOICE,
	CLASS_CHOICE,
	SUBCLASS_CHOICE : in STRING := "")
    is

	CHOSEN_CLASS	    : CLASS_TYPE;
	CHOSEN_SUBCLASS_KEY : INTEGER;

	CHOSEN_ENTRY	    : ENTRY_TYPE;

	CHOSEN_LOCATION     : OBJECTS.OBJECT_LOCATION;
	CHOSEN_ORIENTATION  : WORLD_PHYSICS.POSITION_BASIS;

    begin
	-- Select a class of craft
	--
	CHOSEN_CLASS :=
	    SUPPORTED_CLASSES(SELECT_FROM_MENU(CLASS_MENU, CLASS_CHOICE));

	-- Chose a subclass
	--
	CHOSEN_SUBCLASS_KEY := 0;
	if CLASS_TO_SUBCLASS_PROVIDED(CHOSEN_CLASS) then
	    CHOSEN_SUBCLASS_KEY :=
		SELECT_FROM_MENU(SUBCLASS_MENU(CHOSEN_CLASS),SUBCLASS_CHOICE);
	end if;

	-- Select a entry
	--
	CHOSEN_ENTRY :=
	    SUPPORTED_ENTRIES(SELECT_FROM_MENU(ENTRY_MENU, ENTRY_CHOICE));

	-- Compute the location and orientation
	--
	CHOSEN_LOCATION     := CHOSEN_ENTRY.LOCATION;
	CHOSEN_ORIENTATION  := CHOSEN_ENTRY.ORIENTATION;

	if CHOSEN_ENTRY.ENTRY_CLASS = RANDOMIZE then

	    -- Change the orientation
	    -- Start the right distance out from the origin, facing it
	    --
	    declare
		use TRIG, SCALE_TYPE_TRIG;
		AD : RADIANS := RADIANS(RANDOM.GENERATE)*
				SCALE_TYPE(RADIANS_PER_CIRCLE);
		DISTANCE : METRES := METRES(CHOSEN_LOCATION.I)+METRES(CHOSEN_LOCATION.J);
	    begin
		MOVE_UTILITIES.ROTATE_ABOUT_K(
		    SIN_AD  => SIN(AD),
		    COS_AD  => COS(AD),
		    BASIS   => CHOSEN_ORIENTATION);

		CHOSEN_LOCATION.I := 0.0;
		CHOSEN_LOCATION.J := 0.0;
		MOVE_UTILITIES.ADD_MOVEMENT_TO_LOCATION(
		    CHOSEN_ORIENTATION.J*(-SCALE_TYPE(DISTANCE)),
		    CHOSEN_LOCATION);
	    end;

	end if;

	-- Now return all the info.
	--
	CLASS		:= CHOSEN_CLASS;
	SUBCLASS_KEY	:= CHOSEN_SUBCLASS_KEY;
	LOCATION	:= CHOSEN_LOCATION;
	ORIENTATION	:= CHOSEN_ORIENTATION;
	VELOCITY	:= (0.0, 0.0, 0.0);	-- HACK

    end;


begin

    -- Create menus
    --
    declare
	use MENU_MANAGER;
    begin
	CREATE("Craft", CLASS_MENU);
	for I in SUPPORTED_CLASSES'range loop
	    APPEND(CLASS_TYPE'image(SUPPORTED_CLASSES(I)), I, CLASS_MENU);
	end loop;

	CREATE("Entry", ENTRY_MENU);
	for I in SUPPORTED_ENTRIES'range loop
	    APPEND(SUPPORTED_ENTRIES(I).NAME, I, ENTRY_MENU);
	end loop;
    end;

end;
