package SCORE is
    procedure KILLED_BY(Whom : Natural);
    procedure KILLED   (Whom : Natural; Same_Target : Boolean);
    procedure OTHER_DEATH(Reason : String);
end SCORE;

with TEXT_IO;
package body SCORE is

    OTHER_DEATHS : Natural := 0;

    KILLS,
    DEATHS : array(0..100) of Natural := (0..100=>0);

    procedure SHOW_SCORE is
	SUM_KILLS  : NATURAL := 0;
	SUM_DEATHS : NATURAL := 0;

	procedure PAIR(PLUS,MINUS : NATURAL) is
	    PSTR : constant STRING := INTEGER'image(PLUS);
	    MSTR : constant STRING := INTEGER'image(MINUS);
	begin
	    TEXT_IO.PUT(PSTR&"-"&MSTR(2..MSTR'last));
	end PAIR;

    begin
	for I in 0..100 loop
	    if KILLS(I)+DEATHS(I) /= 0 then
		if SUM_DEATHS+SUM_KILLS=0 then
		    TEXT_IO.Put(" :");
		else
		    TEXT_IO.Put(",");
		end if;
		TEXT_IO.PUT(Integer'image(I)&"=");
		PAIR(KILLS(I), DEATHS(I));
		SUM_KILLS  := SUM_KILLS +KILLS (I);
		SUM_DEATHS := SUM_DEATHS+DEATHS(I);
	    end if;
	end loop;
	if OTHER_DEATHS /= 0 then
	    TEXT_IO.Put(" : Other deaths ="&Integer'image(OTHER_DEATHS));
	    SUM_DEATHS := SUM_DEATHS+OTHER_DEATHS;
	end if;
	TEXT_IO.Put(" (Total :");
	PAIR(SUM_KILLS, SUM_DEATHS);
	TEXT_IO.PUT_LINE(")");
    end SHOW_SCORE;

    procedure KILLED_BY(Whom : Natural) is
    begin
	DEATHS(Whom) := DEATHS(Whom)+1;
	TEXT_IO.PUT("Hit by"&Integer'image(Whom));
	SHOW_SCORE;
    end KILLED_BY;

    procedure OTHER_DEATH(Reason : String) is
    begin
	OTHER_DEATHS := OTHER_DEATHS+1;
	TEXT_IO.PUT(Reason);
	SHOW_SCORE;
    end OTHER_DEATH;

    procedure KILLED   (Whom : Natural; Same_Target : Boolean) is
    begin
	if not Same_Target then
	    KILLS(Whom) := KILLS(Whom)+1;
	    TEXT_IO.PUT("Killed"&Integer'image(Whom));
	    SHOW_SCORE;
	else
	    TEXT_IO.PUT_LINE("  (More hits)");
	end if;
    end KILLED;

end SCORE;
