--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with PHYSICAL_UNITS;
package SCALAR_PHYSICS is

    type SCALE_TYPE is digits 6;

    type KELVIN 			is digits 4;
    type KILOGRAMS			is digits 4;
    type SECONDS			is new DURATION delta 0.01;
    type METRES 			is new PHYSICAL_UNITS.METRES;

    type METRES_SQUARED 		is digits SCALE_TYPE'digits;
    type METRES_CUBED			is digits SCALE_TYPE'digits;

    type METRES_PER_SECOND		is new PHYSICAL_UNITS.METRES_PER_SECOND;
    type METRES_PER_SECOND_SQUARED	is new PHYSICAL_UNITS.METRES_PER_SECOND_SQUARED;

    type NEWTONS			is digits SCALE_TYPE'digits;
    type NEWTONS_PER_METRE_SQUARED	is digits SCALE_TYPE'digits;

    type KILOGRAMS_PER_SECOND		is digits SCALE_TYPE'digits;
    type KILOGRAMS_PER_NEWTON_SECOND	is digits SCALE_TYPE'digits;
    type KILOGRAMS_PER_METRE_CUBED	is digits SCALE_TYPE'digits;


    function "*"(T : KELVIN;			S : SCALE_TYPE  ) return KELVIN;
    function "*"(M : KILOGRAMS;			S : SCALE_TYPE  ) return KILOGRAMS;
    function "*"(T : SECONDS;			S : SCALE_TYPE  ) return SECONDS;
    function "*"(X : METRES;			S : SCALE_TYPE  ) return METRES;
    function "*"(A : METRES_SQUARED;		S : SCALE_TYPE  ) return METRES_SQUARED;
    function "*"(V : METRES_CUBED;		S : SCALE_TYPE  ) return METRES_CUBED;
    function "*"(V : METRES_PER_SECOND; 	S : SCALE_TYPE  ) return METRES_PER_SECOND;
    function "*"(A : METRES_PER_SECOND_SQUARED; S : SCALE_TYPE  ) return METRES_PER_SECOND_SQUARED;
    function "*"(F : NEWTONS;			S : SCALE_TYPE  ) return NEWTONS;
    function "*"(P : NEWTONS_PER_METRE_SQUARED; S : SCALE_TYPE  ) return NEWTONS_PER_METRE_SQUARED;
    function "*"(R : KILOGRAMS_PER_SECOND;	S : SCALE_TYPE  ) return KILOGRAMS_PER_SECOND;
    function "*"(R : KILOGRAMS_PER_NEWTON_SECOND;S: SCALE_TYPE  ) return KILOGRAMS_PER_NEWTON_SECOND;
    function "*"(D : KILOGRAMS_PER_METRE_CUBED; S : SCALE_TYPE  ) return KILOGRAMS_PER_METRE_CUBED;

    function "/"(T : KELVIN;			S : SCALE_TYPE  ) return KELVIN;
    function "/"(M : KILOGRAMS;			S : SCALE_TYPE  ) return KILOGRAMS;
    function "/"(T : SECONDS;			S : SCALE_TYPE  ) return SECONDS;
    function "/"(X : METRES;			S : SCALE_TYPE  ) return METRES;
    function "/"(A : METRES_SQUARED;		S : SCALE_TYPE  ) return METRES_SQUARED;
    function "/"(V : METRES_CUBED;		S : SCALE_TYPE  ) return METRES_CUBED;
    function "/"(V : METRES_PER_SECOND; 	S : SCALE_TYPE  ) return METRES_PER_SECOND;
    function "/"(A : METRES_PER_SECOND_SQUARED; S : SCALE_TYPE  ) return METRES_PER_SECOND_SQUARED;
    function "/"(F : NEWTONS;			S : SCALE_TYPE  ) return NEWTONS;
    function "/"(P : NEWTONS_PER_METRE_SQUARED; S : SCALE_TYPE  ) return NEWTONS_PER_METRE_SQUARED;
    function "/"(R : KILOGRAMS_PER_SECOND;	S : SCALE_TYPE  ) return KILOGRAMS_PER_SECOND;
    function "/"(R : KILOGRAMS_PER_NEWTON_SECOND;S: SCALE_TYPE  ) return KILOGRAMS_PER_NEWTON_SECOND;
    function "/"(D : KILOGRAMS_PER_METRE_CUBED; S : SCALE_TYPE  ) return KILOGRAMS_PER_METRE_CUBED;


    function "*"(V : METRES_PER_SECOND; 	T : SECONDS	) return METRES;
    function "*"(A : METRES_PER_SECOND_SQUARED; T : SECONDS	) return METRES_PER_SECOND;
    function "*"(R : KILOGRAMS_PER_SECOND;	T : SECONDS	) return KILOGRAMS;

    function "/"(X : METRES;			T : SECONDS	) return METRES_PER_SECOND;
    function "/"(V : METRES_PER_SECOND; 	T : SECONDS	) return METRES_PER_SECOND_SQUARED;
    function "/"(M : KILOGRAMS; 		T : SECONDS	) return KILOGRAMS_PER_SECOND;


    function "*"(X : METRES;			Y : METRES	) return METRES_SQUARED;
    function "*"(A : METRES_SQUARED;		Y : METRES	) return METRES_CUBED;

    function "/"(A : METRES_SQUARED;		Y : METRES	) return METRES;
    function "/"(V : METRES_CUBED;		Y : METRES	) return METRES_SQUARED;
    function "/"(V : METRES_CUBED;		A : METRES_SQUARED) return METRES;


    function "*"(P : NEWTONS_PER_METRE_SQUARED; A : METRES_SQUARED) return NEWTONS;
    function "/"(F : NEWTONS;			A : METRES_SQUARED) return NEWTONS_PER_METRE_SQUARED;


    function "*"(M : KILOGRAMS; 		A : METRES_PER_SECOND_SQUARED) return NEWTONS;
    function "/"(F : NEWTONS;			A : METRES_PER_SECOND_SQUARED) return KILOGRAMS;
    function "/"(F : NEWTONS;			M : KILOGRAMS	) return METRES_PER_SECOND_SQUARED;


    function "*"(D : KILOGRAMS_PER_METRE_CUBED; V : METRES_CUBED) return KILOGRAMS;
    function "/"(M : KILOGRAMS; 		X : METRES_CUBED) return KILOGRAMS_PER_METRE_CUBED;


    function "*"(R : KILOGRAMS_PER_NEWTON_SECOND; F : NEWTONS)	  return KILOGRAMS_PER_SECOND;


private
    pragma INLINE("*");
    pragma INLINE("/");

end;
