--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


package body SCALAR_PHYSICS is

    function "*"(T : KELVIN;			S : SCALE_TYPE  ) return KELVIN is
    begin
	return KELVIN(SCALE_TYPE(T)*SCALE_TYPE(S));
    end;

    function "*"(M : KILOGRAMS;			S : SCALE_TYPE  ) return KILOGRAMS is
    begin
	return KILOGRAMS(SCALE_TYPE(M)*SCALE_TYPE(S));
    end;

    function "*"(T : SECONDS;			S : SCALE_TYPE  ) return SECONDS is
    begin
	return SECONDS(SCALE_TYPE(T)*SCALE_TYPE(S));
    end;

    function "*"(X : METRES;			S : SCALE_TYPE  ) return METRES is
    begin
	return METRES(SCALE_TYPE(X)*SCALE_TYPE(S));
    end;

    function "*"(A : METRES_SQUARED;		S : SCALE_TYPE  ) return METRES_SQUARED is
    begin
	return METRES_SQUARED(SCALE_TYPE(A)*SCALE_TYPE(S));
    end;

    function "*"(V : METRES_CUBED;		S : SCALE_TYPE  ) return METRES_CUBED is
    begin
	return METRES_CUBED(SCALE_TYPE(V)*SCALE_TYPE(S));
    end;

    function "*"(V : METRES_PER_SECOND; 	S : SCALE_TYPE  ) return METRES_PER_SECOND is
    begin
	return METRES_PER_SECOND(SCALE_TYPE(V)*SCALE_TYPE(S));
    end;

    function "*"(A : METRES_PER_SECOND_SQUARED; S : SCALE_TYPE  ) return METRES_PER_SECOND_SQUARED is
    begin
	return METRES_PER_SECOND_SQUARED(SCALE_TYPE(A)*SCALE_TYPE(S));
    end;

    function "*"(F : NEWTONS;			S : SCALE_TYPE  ) return NEWTONS is
    begin
	return NEWTONS(SCALE_TYPE(F)*SCALE_TYPE(S));
    end;

    function "*"(P : NEWTONS_PER_METRE_SQUARED; S : SCALE_TYPE  ) return NEWTONS_PER_METRE_SQUARED is
    begin
	return NEWTONS_PER_METRE_SQUARED(SCALE_TYPE(P)*SCALE_TYPE(S));
    end;

    function "*"(R : KILOGRAMS_PER_SECOND;	S : SCALE_TYPE  ) return KILOGRAMS_PER_SECOND is
    begin
	return KILOGRAMS_PER_SECOND(SCALE_TYPE(R)*SCALE_TYPE(S));
    end;

    function "*"(R : KILOGRAMS_PER_NEWTON_SECOND;S: SCALE_TYPE  ) return KILOGRAMS_PER_NEWTON_SECOND is
    begin
	return KILOGRAMS_PER_NEWTON_SECOND(SCALE_TYPE(R)*SCALE_TYPE(S));
    end;

    function "*"(D : KILOGRAMS_PER_METRE_CUBED; S : SCALE_TYPE  ) return KILOGRAMS_PER_METRE_CUBED is
    begin
	return KILOGRAMS_PER_METRE_CUBED(SCALE_TYPE(D)*SCALE_TYPE(S));
    end;


    function "/"(T : KELVIN;			S : SCALE_TYPE  ) return KELVIN is
    begin
	return KELVIN(SCALE_TYPE(T)/SCALE_TYPE(S));
    end;

    function "/"(M : KILOGRAMS;			S : SCALE_TYPE  ) return KILOGRAMS is
    begin
	return KILOGRAMS(SCALE_TYPE(M)/SCALE_TYPE(S));
    end;

    function "/"(T : SECONDS;			S : SCALE_TYPE  ) return SECONDS is
    begin
	return SECONDS(SCALE_TYPE(T)/SCALE_TYPE(S));
    end;

    function "/"(X : METRES;			S : SCALE_TYPE  ) return METRES is
    begin
	return METRES(SCALE_TYPE(X)/SCALE_TYPE(S));
    end;

    function "/"(A : METRES_SQUARED;		S : SCALE_TYPE  ) return METRES_SQUARED is
    begin
	return METRES_SQUARED(SCALE_TYPE(A)/SCALE_TYPE(S));
    end;

    function "/"(V : METRES_CUBED;		S : SCALE_TYPE  ) return METRES_CUBED is
    begin
	return METRES_CUBED(SCALE_TYPE(V)/SCALE_TYPE(S));
    end;

    function "/"(V : METRES_PER_SECOND; 	S : SCALE_TYPE  ) return METRES_PER_SECOND is
    begin
	return METRES_PER_SECOND(SCALE_TYPE(V)/SCALE_TYPE(S));
    end;

    function "/"(A : METRES_PER_SECOND_SQUARED; S : SCALE_TYPE  ) return METRES_PER_SECOND_SQUARED is
    begin
	return METRES_PER_SECOND_SQUARED(SCALE_TYPE(A)/SCALE_TYPE(S));
    end;

    function "/"(F : NEWTONS;			S : SCALE_TYPE  ) return NEWTONS is
    begin
	return NEWTONS(SCALE_TYPE(F)/SCALE_TYPE(S));
    end;

    function "/"(P : NEWTONS_PER_METRE_SQUARED; S : SCALE_TYPE  ) return NEWTONS_PER_METRE_SQUARED is
    begin
	return NEWTONS_PER_METRE_SQUARED(SCALE_TYPE(P)/SCALE_TYPE(S));
    end;

    function "/"(R : KILOGRAMS_PER_SECOND;	S : SCALE_TYPE  ) return KILOGRAMS_PER_SECOND is
    begin
	return KILOGRAMS_PER_SECOND(SCALE_TYPE(R)/SCALE_TYPE(S));
    end;

    function "/"(R : KILOGRAMS_PER_NEWTON_SECOND;S: SCALE_TYPE  ) return KILOGRAMS_PER_NEWTON_SECOND is
    begin
	return KILOGRAMS_PER_NEWTON_SECOND(SCALE_TYPE(R)/SCALE_TYPE(S));
    end;

    function "/"(D : KILOGRAMS_PER_METRE_CUBED; S : SCALE_TYPE  ) return KILOGRAMS_PER_METRE_CUBED is
    begin
	return KILOGRAMS_PER_METRE_CUBED(SCALE_TYPE(D)/SCALE_TYPE(S));
    end;



    function "*"(V : METRES_PER_SECOND; 	T : SECONDS	) return METRES is
    begin
	return METRES(SCALE_TYPE(V)*SCALE_TYPE(T));
    end;

    function "*"(A : METRES_PER_SECOND_SQUARED; T : SECONDS	) return METRES_PER_SECOND is
    begin
	return METRES_PER_SECOND(SCALE_TYPE(A)*SCALE_TYPE(T));
    end;

    function "*"(R : KILOGRAMS_PER_SECOND;	T : SECONDS	) return KILOGRAMS is
    begin
	return KILOGRAMS(SCALE_TYPE(R)*SCALE_TYPE(T));
    end;


    function "/"(X : METRES;			T : SECONDS	) return METRES_PER_SECOND is
    begin
	return METRES_PER_SECOND(SCALE_TYPE(X)/SCALE_TYPE(T));
    end;

    function "/"(V : METRES_PER_SECOND; 	T : SECONDS	) return METRES_PER_SECOND_SQUARED is
    begin
	return METRES_PER_SECOND_SQUARED(SCALE_TYPE(V)/SCALE_TYPE(T));
    end;

    function "/"(M : KILOGRAMS; 		T : SECONDS	) return KILOGRAMS_PER_SECOND is
    begin
	return KILOGRAMS_PER_SECOND(SCALE_TYPE(M)/SCALE_TYPE(T));
    end;



    function "*"(X : METRES;			Y : METRES	) return METRES_SQUARED is
    begin
	return METRES_SQUARED(SCALE_TYPE(X)*SCALE_TYPE(Y));
    end;

    function "*"(A : METRES_SQUARED;		Y : METRES	) return METRES_CUBED is
    begin
	return METRES_CUBED(SCALE_TYPE(A)*SCALE_TYPE(Y));
    end;


    function "/"(A : METRES_SQUARED;		Y : METRES	) return METRES is
    begin
	return METRES(SCALE_TYPE(A)/SCALE_TYPE(Y));
    end;

    function "/"(V : METRES_CUBED;		Y : METRES	) return METRES_SQUARED is
    begin
	return METRES_SQUARED(SCALE_TYPE(V)/SCALE_TYPE(Y));
    end;

    function "/"(V : METRES_CUBED;		A : METRES_SQUARED) return METRES is
    begin
	return METRES(SCALE_TYPE(V)/SCALE_TYPE(A));
    end;



    function "*"(P : NEWTONS_PER_METRE_SQUARED; A : METRES_SQUARED) return NEWTONS is
    begin
	return NEWTONS(SCALE_TYPE(P)*SCALE_TYPE(A));
    end;

    function "/"(F : NEWTONS;			A : METRES_SQUARED) return NEWTONS_PER_METRE_SQUARED is
    begin
	return NEWTONS_PER_METRE_SQUARED(SCALE_TYPE(F)/SCALE_TYPE(A));
    end;


    function "*"(M : KILOGRAMS; 		A : METRES_PER_SECOND_SQUARED) return NEWTONS is
    begin
	return NEWTONS(SCALE_TYPE(M)*SCALE_TYPE(A));
    end;

    function "/"(F : NEWTONS;			A : METRES_PER_SECOND_SQUARED) return KILOGRAMS is
    begin
	return KILOGRAMS(SCALE_TYPE(F)/SCALE_TYPE(A));
    end;

    function "/"(F : NEWTONS;			M : KILOGRAMS	) return METRES_PER_SECOND_SQUARED is
    begin
	return METRES_PER_SECOND_SQUARED(SCALE_TYPE(F)/SCALE_TYPE(M));
    end;



    function "*"(D : KILOGRAMS_PER_METRE_CUBED; V : METRES_CUBED) return KILOGRAMS is
    begin
	return KILOGRAMS(SCALE_TYPE(D)*SCALE_TYPE(V));
    end;

    function "/"(M : KILOGRAMS; 		X : METRES_CUBED) return KILOGRAMS_PER_METRE_CUBED is
    begin
	return KILOGRAMS_PER_METRE_CUBED(SCALE_TYPE(M)/SCALE_TYPE(X));
    end;


    function "*"(R : KILOGRAMS_PER_NEWTON_SECOND; F : NEWTONS)    return KILOGRAMS_PER_SECOND is
    begin
	return KILOGRAMS_PER_SECOND(SCALE_TYPE(R)*SCALE_TYPE(F));
    end;

end;
