--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with OBJECT_PHYSICS, TRIG, SCALAR_PHYSICS, SCALE_TYPE_TRIG;
use  OBJECT_PHYSICS, TRIG, SCALAR_PHYSICS, SCALE_TYPE_TRIG;
procedure ROTATE_ORIENTATION(
    ORIENTATION : in out OBJECT_PHYSICS.POSITION_BASIS;
    PITCH,
    ROLL,
    YAW 	: RADIANS)
is
    NEW_I_I, NEW_I_J, NEW_I_K,
    NEW_J_I, NEW_J_J, NEW_J_K,
    NEW_K_I, NEW_K_J, NEW_K_K : METRES;

    OLD_I_I : METRES := ORIENTATION.I.I;
    OLD_I_J : METRES := ORIENTATION.I.J;
    OLD_I_K : METRES := ORIENTATION.I.K;

    OLD_J_I : METRES := ORIENTATION.J.I;
    OLD_J_J : METRES := ORIENTATION.J.J;
    OLD_J_K : METRES := ORIENTATION.J.K;

    OLD_K_I : METRES := ORIENTATION.K.I;
    OLD_K_J : METRES := ORIENTATION.K.J;
    OLD_K_K : METRES := ORIENTATION.K.K;

begin
    -- PITCH
    --
    declare
	A : RADIANS renames PITCH;

	SIN_A : constant SCALE_TYPE := SIN(A);
	COS_A : constant SCALE_TYPE := COS(A);

    begin
	-- J maps to POSITION'(0.0, COS_A, SIN_A);
	--
--		NEW_J := ORIENTATION.J*COS_A + ORIENTATION.K*SIN_A;
	NEW_J_I := OLD_J_I*COS_A + OLD_K_I*SIN_A;
	NEW_J_J := OLD_J_J*COS_A + OLD_K_J*SIN_A;
	NEW_J_K := OLD_J_K*COS_A + OLD_K_K*SIN_A;

	-- K maps to POSITION'(0.0, -SIN_A, COS_A);
	--
--		NEW_K := ORIENTATION.J*(-SIN_A) + ORIENTATION.K*COS_A;
	OLD_K_I := OLD_K_I*COS_A - OLD_J_I*SIN_A;
	OLD_K_J := OLD_K_J*COS_A - OLD_J_J*SIN_A;
	OLD_K_K := OLD_K_K*COS_A - OLD_J_K*SIN_A;

	-- Update
	--
--		ORIENTATION.J := NEW_J;
	OLD_J_I := NEW_J_I;
	OLD_J_J := NEW_J_J;
	OLD_J_K := NEW_J_K;
--		ORIENTATION.K := NEW_K;
--		merged above
    end;

    -- ROLL
    --
    declare
	A : RADIANS renames ROLL;

	SIN_A : constant SCALE_TYPE := SIN(A);
	COS_A : constant SCALE_TYPE := COS(A);

    begin
	-- I maps to POSITION'(COS_A, 0.0, SIN_A);
	--
--		NEW_I := ORIENTATION.I*COS_A + ORIENTATION.K*SIN_A;
	NEW_I_I := OLD_I_I*COS_A + OLD_K_I*SIN_A;
	NEW_I_J := OLD_I_J*COS_A + OLD_K_J*SIN_A;
	NEW_I_K := OLD_I_K*COS_A + OLD_K_K*SIN_A;

	-- K maps to POSITION'(-SIN_A, 0.0, COS_A);
	--
--		NEW_K := ORIENTATION.I*(-SIN_A) + ORIENTATION.K*COS_A;
	ORIENTATION.K.I := OLD_K_I*COS_A - OLD_I_I*SIN_A;
	ORIENTATION.K.J := OLD_K_J*COS_A - OLD_I_J*SIN_A;
	ORIENTATION.K.K := OLD_K_K*COS_A - OLD_I_K*SIN_A;

	-- Update
	--
--		ORIENTATION.I := NEW_I;
	OLD_I_I := NEW_I_I;
	OLD_I_J := NEW_I_J;
	OLD_I_K := NEW_I_K;
--		ORIENTATION.K := NEW_K;
--		merged above
    end;

    -- YAW
    --
    declare
	A : RADIANS renames YAW;

	SIN_A : constant SCALE_TYPE := SIN(A);
	COS_A : constant SCALE_TYPE := COS(A);

    begin
	-- I maps to POSITION'(COS_A, SIN_A, 0.0);
	--
--		NEW_I := ORIENTATION.I*COS_A + ORIENTATION.J*SIN_A;
	ORIENTATION.I.I := OLD_I_I*COS_A + OLD_J_I*SIN_A;
	ORIENTATION.I.J := OLD_I_J*COS_A + OLD_J_J*SIN_A;
	ORIENTATION.I.K := OLD_I_K*COS_A + OLD_J_K*SIN_A;

	-- J maps to POSITION'(-SIN_A, COS_A, 0.0);
	--
--		NEW_J := ORIENTATION.I*(-SIN_A) + ORIENTATION.J*COS_A;
	ORIENTATION.J.I := OLD_J_I*COS_A - OLD_I_I*SIN_A;
	ORIENTATION.J.J := OLD_J_J*COS_A - OLD_I_J*SIN_A;
	ORIENTATION.J.K := OLD_J_K*COS_A - OLD_I_K*SIN_A;

	-- Update
	--
--		ORIENTATION.I := NEW_I;
--		ORIENTATION.J := NEW_J;
    end;
end;
pragma SUPPRESS_ALL;
pragma INLINE(ROTATE_ORIENTATION);
