--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    UNCHECKED_DEALLOCATION,
    SCALAR_PHYSICS, WORLD_PHYSICS,
    OBJECTS,
    APPEARANCE_MANAGER, INFO_MANAGER,
    MAIN_SIMULATION, FLIGHT_RECORDER;
use
    OBJECTS,
    MAIN_SIMULATION;

pragma ELABORATE(
    UNCHECKED_DEALLOCATION,
    SCALAR_PHYSICS, WORLD_PHYSICS,
    OBJECTS,
    APPEARANCE_MANAGER, INFO_MANAGER);

package body RIBBON_MANAGER is

    type RIBBON_CURVE_TYPE is
	record
	    OBJECT	    : OBJECTS.ACCESS_OBJECT_TYPE := null;
	    APPEARANCE	    : APPEARANCE_MANAGER.ACCESS_APPEARANCE_TYPE;
	    SUBPICTURE_CNT  : NATURAL := 0;
	    SUBPICTURE_AGE  : NATURAL := 0;
	end record;

    type VECTOR_OF_RIBBON_CURVE_TYPE is
	array(POSITIVE range <>) of RIBBON_CURVE_TYPE;

    type RIBBON_TYPE;

    type ACCESS_RIBBON_TYPE is access RIBBON_TYPE;

    type RIBBON_TYPE is
	record
	    NEXT		    : ACCESS_RIBBON_TYPE;

	    RELATED_SEQUENCE_NUMBER : POSITIVE;
	    RELATED_OBJECT_INFO     : INFO_MANAGER.OBJECT_INFO_TYPE;

	    CURVES		    : VECTOR_OF_RIBBON_CURVE_TYPE(1..2);
	end record;

    LIST_OF_RIBBONS		: ACCESS_RIBBON_TYPE := null;

    RIBBON_CLOCK_TICK		: constant POSITIVE := 8;
    RIBBON_CLOCK_SUBPICTURE_TICK: constant POSITIVE := 80;

    RIBBON_CLOCK		: INTEGER := 0;
    RIBBON_SUBPICTURE_COUNT 	: NATURAL := 0;


    function FIND_RIBBON(OBJ : OBJECT_TYPE) return ACCESS_RIBBON_TYPE is
	use APPEARANCE_MANAGER, OBJECTS;

	AR : ACCESS_RIBBON_TYPE := LIST_OF_RIBBONS;

    begin
	while AR /= null loop
	    declare
		use INFO_MANAGER;
		R : RIBBON_TYPE renames AR.all;
	    begin
		if  R.RELATED_SEQUENCE_NUMBER = OBJ.SEQUENCE_NUMBER
		and R.RELATED_OBJECT_INFO     = OBJ.OBJECT_INFO
		then
		    return AR;
		end if;
		AR := R.NEXT;
	    end;
	end loop;

	AR := new RIBBON_TYPE;
	AR.NEXT := LIST_OF_RIBBONS;
	AR.RELATED_SEQUENCE_NUMBER := OBJ.SEQUENCE_NUMBER;
	AR.RELATED_OBJECT_INFO := OBJ.OBJECT_INFO;
	for I in AR.CURVES'range loop
	    declare
		C		: RIBBON_CURVE_TYPE renames AR.CURVES(I);
		APPEARANCE_INFO : constant INFO_MANAGER.APPEARANCE_INFO_TYPE
				:= CREATE;
	    begin
		C.OBJECT :=
		    CREATE(NONE_NEEDED, BUILDING, 0,
			(0.0, 0.0, 0.0),
			WORLD_PHYSICS.USUAL_POSITION_BASIS,
			(0.0, 0.0, 0.0));
		C.OBJECT.APPEARANCE_INFO := APPEARANCE_INFO;

		C.APPEARANCE :=
		    TO_ACCESS_APPEARANCE_TYPE(APPEARANCE_INFO);
		FINISH_CREATING_SUBPICTURES(C.APPEARANCE);

		ADD_ONE_OBJECT(C.OBJECT);
	    end;
	end loop;

	LIST_OF_RIBBONS := AR;
	return AR;
    end;

    procedure DELETE_ALL_RIBBONS is
	AR : ACCESS_RIBBON_TYPE;
	procedure DEALLOCATE is
	    new UNCHECKED_DEALLOCATION(RIBBON_TYPE, ACCESS_RIBBON_TYPE);
    begin
	loop
	    AR := LIST_OF_RIBBONS;
	    exit when AR = null;
	    LIST_OF_RIBBONS := AR.NEXT;
	    for I in AR.CURVES'range loop
		declare
		    C : RIBBON_CURVE_TYPE renames AR.CURVES(I);
		begin
		    REMOVE_ONE_OBJECT(C.OBJECT);
		    APPEARANCE_MANAGER.DELETE(C.APPEARANCE);
		end;
	    end loop;
	    DEALLOCATE(AR);
	end loop;
    end;

    procedure UPDATE_ALL_RIBBONS(ELAPSED : SCALAR_PHYSICS.SECONDS) is
	use APPEARANCE_MANAGER;
	AR : ACCESS_RIBBON_TYPE := LIST_OF_RIBBONS;
    begin
	if LENGTH = 0 then
	    DELETE_ALL_RIBBONS;
	    return;
	end if;

	if FLIGHT_RECORDER.SPEED = 0
	and ONLY_FROM_FLIGHT_RECORDER
	then
	    return;
	end if;

	RIBBON_CLOCK := RIBBON_CLOCK + 1;
	if RIBBON_CLOCK rem RIBBON_CLOCK_SUBPICTURE_TICK /= 0 then
	    return;
	end if;

	while AR /= null loop
	    declare
		use INFO_MANAGER;
		R : RIBBON_TYPE renames AR.all;
	    begin
		for I in R.CURVES'range loop
		    declare
			C : RIBBON_CURVE_TYPE renames R.CURVES(I);
			EXCESS : INTEGER;
		    begin
			C.SUBPICTURE_CNT := C.SUBPICTURE_CNT + 1;
			C.SUBPICTURE_AGE := C.SUBPICTURE_AGE + 1;
			REOPEN_CREATING_SUBPICTURES(C.APPEARANCE);
			ADD_SUBPICTURE(C.APPEARANCE);
			FINISH_CREATING_SUBPICTURES(C.APPEARANCE);
			EXCESS := C.SUBPICTURE_AGE-LENGTH;
			if EXCESS > 0 then
			    DELETE_FIRST_SUBPICTURES(C.APPEARANCE, EXCESS);
			    C.SUBPICTURE_AGE := C.SUBPICTURE_AGE - EXCESS;
			end if;
		    end;
		end loop;
		AR := R.NEXT;
	    end;
	end loop;
    end;

    procedure EXTEND(OBJ : OBJECT_TYPE) is
    begin
	if RIBBON_CLOCK rem RIBBON_CLOCK_TICK = 0 then
	    declare
		use SCALAR_PHYSICS;

		R : RIBBON_TYPE renames FIND_RIBBON(OBJ).all;

		procedure EXTEND(I : INTEGER; S : SCALE_TYPE) is
		    use APPEARANCE_MANAGER;
		    C : RIBBON_CURVE_TYPE renames R.CURVES(I);
		begin
		    REOPEN_CREATING_SUBPICTURES(C.APPEARANCE);
		    ADD_POINT(C.APPEARANCE,
			(METRES(OBJ.LOCATION.I)+OBJ.ORIENTATION.I.I*S,
			 METRES(OBJ.LOCATION.J)+OBJ.ORIENTATION.I.J*S,
			 METRES(OBJ.LOCATION.K)+OBJ.ORIENTATION.I.K*S));
		    FINISH_CREATING_SUBPICTURES(C.APPEARANCE);
		end;

	    begin
		EXTEND(1, -50.0);
		EXTEND(2,  50.0);
	    end;
	end if;
    end;

end;
