--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


package PHYSICS_GUESSES is

    -- some physical constants
    --
    G : constant := 9.8;

    -- establish some minimums and maximums for the physical dimensions
    --
    MAX_METRES : constant := 10_000_000.0;
    MIN_METRES : constant := 0.01;

    DIGITS_ACCURACY : constant := 6;

    MAX_SPEED_OF_SOUND : constant := 760.0	-- miles per hour at sea level
				/(60.0*60.0)	-- hours -> seconds
				*(8.0/5.0)	-- miles -> kilometres
				*1000.0;	-- kilometres -> metres

    MAX_SPEED  : constant := 20*MAX_SPEED_OF_SOUND;
    MAX_ACCELERATION : constant := 50*G;

    type METRES is
	digits DIGITS_ACCURACY range -MAX_METRES .. MAX_METRES;

    type METRES_PER_SECOND is
	digits DIGITS_ACCURACY range -MAX_SPEED .. MAX_SPEED;

    type METRES_PER_SECOND_SQUARED is
	digits DIGITS_ACCURACY
	range -MAX_ACCELERATION .. MAX_ACCELERATION;

end;
