--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    AEROPLANE, MAGIC_CARPET, BULLETS, MISSILE;

separate(OBJECTS)
    function CREATE(
	MAINTAINER	: MAINTAINER_TYPE;
	CLASS		: CLASS_TYPE;
	SUBCLASS	: SUBCLASS_TYPE;
	LOCATION	: OBJECT_LOCATION;
	ORIENTATION	: WORLD_PHYSICS.POSITION_BASIS;
	VELOCITY	: WORLD_PHYSICS.VELOCITY)
	return ACCESS_OBJECT_TYPE
    is
	A : constant ACCESS_OBJECT_TYPE := new OBJECT_TYPE;
	O : OBJECT_TYPE renames A.all;
    begin

	SEQUENCE_NUMBER := SEQUENCE_NUMBER + 1;
	O.SEQUENCE_NUMBER := SEQUENCE_NUMBER;
	O.OBJECT_INFO	:= ASSIGN;

	O.CLASS 	:= CLASS;
	O.SUBCLASS	:= SUBCLASS;
	O.MAINTAINER	:= MAINTAINER;

	O.LOCATION	:= LOCATION;
	O.ORIENTATION   := ORIENTATION;
	O.VELOCITY	:= VELOCITY;

	O.VIEW_LOCATION := (0.0, 0.0, 0.0);

	O.OLD_LOCATION	:= LOCATION;

	OBJECT_INFO_TO_ACCESS_OBJECT(O.OBJECT_INFO) := A;

	case CLASS is
	    when AEROPLANE	=> STANDARD.AEROPLANE   .CREATED(O);
	    when MAGIC_CARPET   => STANDARD.MAGIC_CARPET.CREATED(O);
	    when BULLETS	=> STANDARD.BULLETS     .CREATED(O);
	    when MISSILE	=> STANDARD.MISSILE     .CREATED(O);
	    when others 	=> null;
	end case;

	return A;
    end;
