--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    INFO_MANAGER, OBJECT_PHYSICS, SCALAR_PHYSICS, WORLD_PHYSICS;
use
    INFO_MANAGER,		  SCALAR_PHYSICS, WORLD_PHYSICS;
pragma ELABORATE(
    INFO_MANAGER, OBJECT_PHYSICS, SCALAR_PHYSICS, WORLD_PHYSICS);

package OBJECTS is



    type CLASS_TYPE is
	(-- stationary
	 GROUND,    RUNWAY,	SEA,	BUILDING,

	 -- uncontrollable
	 BULLETS,   MISSILE,

	 -- controllable
	 AEROPLANE, HELICOPTER, MAGIC_CARPET,
	 SURFACE_VEHICLE,
	 SUBMARINE
	);

    subtype STATIONARY_CLASS_SUBTYPE is
	CLASS_TYPE range GROUND..BUILDING;

    subtype UNCONTROLLABLE_CLASS_SUBTYPE is
	CLASS_TYPE range BULLETS..MISSILE;

    subtype CONTROLLABLE_CLASS_SUBTYPE is
	CLASS_TYPE range AEROPLANE..SUBMARINE;

    subtype TARGET_CLASS_SUBTYPE is
	CLASS_TYPE range AEROPLANE..SUBMARINE;
	

    type MAINTAINER_TYPE is
	(NONE_NEEDED, THIS_SIMULATOR, ANOTHER_SIMULATOR);


    -- OBJECT_LOCATION's differ from WORLD_PHYSICS.POSITION in that
    -- their accuracy is independent of the origin.
    --
    type OBJECT_LOCATION_COORDINATE is
	delta 0.01 range -5_000_000.0 .. 5_000_000.0; -- METRES

    type OBJECT_LOCATION is
	record
	    I, J, K : OBJECT_LOCATION_COORDINATE;
	end record; for OBJECT_LOCATION use record at mod 4; end record;


    type OBJECT_INFO_HASH_TYPE is range 0..127;

    type EXTRA_RADIUS_TYPE is
	record
	    RADIUS	    : METRES		    := 0.0;
	    ORIGIN	    : OBJECT_PHYSICS.POSITION;
	end record;

    type VECTOR_OF_EXTRA_RADIUS_TYPE is
	array(POSITIVE range <>) of EXTRA_RADIUS_TYPE;


    type OBJECT_TYPE;
    type ACCESS_OBJECT_TYPE is access OBJECT_TYPE;

    type OBJECT_TYPE is
	record
	    SEQUENCE_NUMBER : POSITIVE;

	    -- following fields are of misc sizes
	    --
	    OBJECT_INFO     : OBJECT_INFO_TYPE;
	    OBJECT_INFO_HASH: OBJECT_INFO_HASH_TYPE;

	    CLASS	    : CLASS_TYPE;
	    MAINTAINER	    : MAINTAINER_TYPE;

	    APPEARANCE_INFO : APPEARANCE_INFO_TYPE  := 0;
	    CLASS_INFO	    : CLASS_INFO_TYPE	    := 0;
	    SUBCLASS	    : SUBCLASS_TYPE	    := 0;
	    SUBCLASS_INFO   : SUBCLASS_INFO_TYPE    := 0;
	    WEAPON_INFO     : WEAPON_INFO_TYPE	    := 0;

	    DELETE_PENDING  : BOOLEAN		    := FALSE;	-- moved from
								-- below

	    -- Location is aligned on a mod-4 boundary
	    --
	    LOCATION	    : OBJECT_LOCATION;
	    ORIENTATION     : WORLD_PHYSICS.POSITION_BASIS;
	    VELOCITY	    : WORLD_PHYSICS.VELOCITY;

	    -- Observer position when in object
	    --
	    VIEW_LOCATION   : OBJECT_PHYSICS.POSITION;

	    -- Fields to help the main simulation
	    --
	    PREV,NEXT	    : ACCESS_OBJECT_TYPE;
	    DELETE_NEXT	    : ACCESS_OBJECT_TYPE;
	    -- DELETE_PENDING  : BOOLEAN := FALSE;  -- moved above

	    -- Fields for collision detection and extrapolation
	    --
	    OLD_LOCATION    : OBJECT_LOCATION;
	    TIME_SINCE_OLD  : SCALAR_PHYSICS.SECONDS;

	    RADIUS	    : METRES;
	    EXTRA_RADII     : VECTOR_OF_EXTRA_RADIUS_TYPE(1..5);

	end record;


    type MAINTAINER_TO_ACCESS_OBJECT_TYPE is
	array(MAINTAINER_TYPE) of ACCESS_OBJECT_TYPE;


    function TO_ACCESS_OBJECT_TYPE(
	OBJECT_INFO : OBJECT_INFO_TYPE) return ACCESS_OBJECT_TYPE;


    function CREATE(
	MAINTAINER	: MAINTAINER_TYPE;
	CLASS		: CLASS_TYPE;
	SUBCLASS	: SUBCLASS_TYPE;
	LOCATION	: OBJECT_LOCATION;
	ORIENTATION	: WORLD_PHYSICS.POSITION_BASIS;
	VELOCITY	: WORLD_PHYSICS.VELOCITY)
	return ACCESS_OBJECT_TYPE;


    procedure DELETE(OBJECT : in out ACCESS_OBJECT_TYPE);

end;
