--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with UNCHECKED_DEALLOCATION;
package body OBJECTS is


    SEQUENCE_NUMBER : NATURAL := 0;

    MAX_OBJECTS : constant OBJECT_INFO_TYPE := 255;
    OBJECT_INFO_TO_ACCESS_OBJECT :
	array(1..MAX_OBJECTS) of ACCESS_OBJECT_TYPE;


    function TO_ACCESS_OBJECT_TYPE(
	OBJECT_INFO : OBJECT_INFO_TYPE) return ACCESS_OBJECT_TYPE is
    begin
	return OBJECT_INFO_TO_ACCESS_OBJECT(OBJECT_INFO);
    end;


    function CREATE(
	MAINTAINER	: MAINTAINER_TYPE;
	CLASS		: CLASS_TYPE;
	SUBCLASS	: SUBCLASS_TYPE;
	LOCATION	: OBJECT_LOCATION;
	ORIENTATION	: WORLD_PHYSICS.POSITION_BASIS;
	VELOCITY	: WORLD_PHYSICS.VELOCITY)
	return ACCESS_OBJECT_TYPE is separate;


    procedure DELETE(OBJECT : in out ACCESS_OBJECT_TYPE) is separate;

end;
