--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with OBJECTS, SCALAR_PHYSICS;

procedure OBJECT_VELOCITY_TO_WORLD_VELOCITY(
    ORIENTATION : in  WORLD_PHYSICS.POSITION_BASIS;
    VELOCITY    : in  OBJECT_PHYSICS.VELOCITY;
    VELOCITY2	: out WORLD_PHYSICS.VELOCITY) is

    use SCALAR_PHYSICS;

	-- OBJECT_RELATIVE_MOVEMENT : constant OBJECT_PHYSICS.POSITION
	--
	ORV_I : constant METRES_PER_SECOND := VELOCITY.I;
	ORV_J : constant METRES_PER_SECOND := VELOCITY.J;
	ORV_K : constant METRES_PER_SECOND := VELOCITY.K;

    begin
	VELOCITY2.I :=
	    ORV_I*SCALE_TYPE(ORIENTATION.I.I) + 
	    ORV_J*SCALE_TYPE(ORIENTATION.J.I) + 
	    ORV_K*SCALE_TYPE(ORIENTATION.K.I);

	VELOCITY2.J :=
	    ORV_I*SCALE_TYPE(ORIENTATION.I.J) + 
	    ORV_J*SCALE_TYPE(ORIENTATION.J.J) + 
	    ORV_K*SCALE_TYPE(ORIENTATION.K.J);

	VELOCITY2.K :=
	    ORV_I*SCALE_TYPE(ORIENTATION.I.K) + 
	    ORV_J*SCALE_TYPE(ORIENTATION.J.K) + 
	    ORV_K*SCALE_TYPE(ORIENTATION.K.K);
    end;

