--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with THREE_DIMENSIONAL_PHYSICS;
package OBJECT_PHYSICS is new THREE_DIMENSIONAL_PHYSICS;

with SCALAR_PHYSICS, OBJECT_PHYSICS;
use  SCALAR_PHYSICS, OBJECT_PHYSICS;
package OBJECT_PHYSICS_EXTRA is

    ONE_METRE_RIGHT : constant POSITION := (1.0, 0.0, 0.0);
    ONE_METRE_AHEAD : constant POSITION := (0.0, 1.0, 0.0);
    ONE_METRE_ABOVE : constant POSITION := (0.0, 0.0, 1.0);

    function AHEAD	(P : POSITION) return METRES;
    function RIGHT	(P : POSITION) return METRES;
    function ABOVE	(P : POSITION) return METRES;

    function TO_POSITION(AHEAD, RIGHT, ABOVE : METRES)
	return POSITION;

    procedure INIT_POSITION(AHEAD, RIGHT, ABOVE : METRES;
			    P : out POSITION);

private
    pragma INLINE(AHEAD, RIGHT, ABOVE, TO_POSITION, INIT_POSITION);

end;
