--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


package body MOVE_UTILITIES is

    procedure ROTATE_ABOUT_K(
	SIN_AD, COS_AD	: SCALAR_PHYSICS.SCALE_TYPE;
	BASIS		: in out WORLD_PHYSICS.POSITION_BASIS) is

	use SCALAR_PHYSICS;

	BI_I : constant METRES := BASIS.I.I;
	BI_J : constant METRES := BASIS.I.J;
	BJ_I : constant METRES := BASIS.J.I;
	BJ_J : constant METRES := BASIS.J.J;

    begin
	BASIS.I.I := (BI_I*COS_AD - BI_J*SIN_AD);
	BASIS.I.J := (BI_I*SIN_AD + BI_J*COS_AD);
	BASIS.J.I := (BJ_I*COS_AD - BJ_J*SIN_AD);
	BASIS.J.J := (BJ_I*SIN_AD + BJ_J*COS_AD);
    end;

    procedure ADD_MOVEMENT_TO_LOCATION(
	MOVEMENT    : WORLD_PHYSICS.POSITION;
	LOCATION    : in out OBJECTS.OBJECT_LOCATION) is

	use OBJECTS, SCALAR_PHYSICS;

    begin
	LOCATION.I := LOCATION.I + OBJECT_LOCATION_COORDINATE(MOVEMENT.I);
	LOCATION.J := LOCATION.J + OBJECT_LOCATION_COORDINATE(MOVEMENT.J);
	LOCATION.K := LOCATION.K + OBJECT_LOCATION_COORDINATE(MOVEMENT.K);
    end;

end;

