--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    NYI,
    MAIN_SIMULATION,
    CONTROLS, INSTRUMENTS, INTERACTIVE_CONTROLS, MOVE,
    VIEW_DIRECTION_CONTROL, VIEW_DIRECTION_MANAGER, VIEW_MANAGER, WEAPONS,
    CONTROLLED_OBJECT,
    SCALAR_PHYSICS, WORLD_PHYSICS;

with
    MOVE_THIS_SIMULATORS_OBJECTS_CONTEXT;

procedure MOVE_THIS_SIMULATORS_OBJECTS(
    LIST_OF_OBJECTS : OBJECTS.ACCESS_OBJECT_TYPE) is

    use SCALAR_PHYSICS;

    CONTROL_SETTING :  CONTROLS.CONTROL_SETTING_TYPE;

begin

    -- Get the latest setting for the controls
    --
    INTERACTIVE_CONTROLS.UPDATE_NON_VOLATILE_AND_COPY(CONTROL_SETTING);

    -- Move each object
    --
    declare
	use OBJECTS;
	P : ACCESS_OBJECT_TYPE := LIST_OF_OBJECTS;
    begin
	while P /= null loop
	    declare
		O : OBJECT_TYPE renames P.all;
	    begin
		O.OLD_LOCATION := O.LOCATION;

		if O.DELETE_PENDING then
		    null;

		elsif P = CONTROLLED_OBJECT.OBJECT_TO_BE_CONTROLLED then
		    case O.CLASS is

			when STATIONARY_CLASS_SUBTYPE =>
			    raise PROGRAM_ERROR;

			when BULLETS =>
				MOVE.BULLETS.CONTROLLED(O, CONTROL_SETTING);

			when MISSILE =>
				MOVE.MISSILE.CONTROLLED(O, CONTROL_SETTING);

			when AEROPLANE =>
				MOVE.AEROPLANE.CONTROLLED(O, CONTROL_SETTING);

			when HELICOPTER =>
				MOVE.HELICOPTER.CONTROLLED(O, CONTROL_SETTING);

			when MAGIC_CARPET =>
				MOVE.MAGIC_CARPET.CONTROLLED(O, CONTROL_SETTING);

			when SURFACE_VEHICLE =>
				MOVE.SURFACE_VEHICLE.CONTROLLED(O, CONTROL_SETTING);

			when SUBMARINE =>
				MOVE.SUBMARINE.CONTROLLED(O, CONTROL_SETTING);

		    end case;

		    -- Delete if necessary
		    --
		    if O.DELETE_PENDING then
			O.DELETE_PENDING := FALSE;
			MAIN_SIMULATION.SET_DELETE_PENDING(P);
		    end if;

		else
		    case O.CLASS is

			when STATIONARY_CLASS_SUBTYPE =>
			    raise PROGRAM_ERROR;

			when BULLETS =>
				MOVE.BULLETS.AUTOMATIC(O);

			when MISSILE =>
				MOVE.MISSILE.AUTOMATIC(O);

			when AEROPLANE =>
				MOVE.AEROPLANE.AUTOMATIC(O);

			when HELICOPTER =>
				MOVE.HELICOPTER.AUTOMATIC(O);

			when MAGIC_CARPET =>
				MOVE.MAGIC_CARPET.AUTOMATIC(O);

			when SURFACE_VEHICLE =>
				MOVE.SURFACE_VEHICLE.AUTOMATIC(O);

			when SUBMARINE =>
				MOVE.SUBMARINE.AUTOMATIC(O);

		    end case;

		    if O.DELETE_PENDING then
			O.DELETE_PENDING := FALSE;
			MAIN_SIMULATION.SET_DELETE_PENDING(P);
		    end if;

		end if;

		P := O.NEXT;
	    end;
	end loop;
    end;

    if CONTROL_SETTING.CHANGE_PRESSED then
	MAIN_SIMULATION.REQUEST_TO_SELECT_NEW_CONTROLLED_OBJECT;
    end if;

    if CONTROL_SETTING.QUIT_PRESSED then
	MAIN_SIMULATION.REQUEST_TO_QUIT;
    end if;

    -- Tweaks for controlled objects
    --
    if OBJECTS."/="(CONTROLLED_OBJECT.OBJECT_TO_BE_CONTROLLED, null) then
	declare
	    O : OBJECTS.OBJECT_TYPE renames
		CONTROLLED_OBJECT.OBJECT_TO_BE_CONTROLLED.all;
	begin
	    WEAPONS.OBEY_CONTROLS(
		CONTROL_SETTING,
		MAIN_SIMULATION.ELAPSED_SINCE_LAST_ITERATION,
		O);

	    INSTRUMENTS.SET(INSTRUMENTS.ALT,
		INSTRUMENTS.VALUE_TYPE(O.LOCATION.K));

	    INSTRUMENTS.SET(INSTRUMENTS.SPEED,
		INSTRUMENTS.VALUE_TYPE(WORLD_PHYSICS.LENGTH(O.VELOCITY)));

	    -- Modify the controls and set them
	    --
	    CONTROL_SETTING.TRIGGER1_PRESSED    := FALSE;
	    CONTROL_SETTING.TRIGGER2_PRESSED    := FALSE;
	    CONTROL_SETTING.TRIGGER1_RELEASED   := FALSE;
	    CONTROL_SETTING.TRIGGER2_RELEASED   := FALSE;

	    CONTROL_SETTING.CHANGE_PRESSED	:= FALSE;
	    CONTROL_SETTING.QUIT_PRESSED	:= FALSE;

	    INTERACTIVE_CONTROLS.SET_CONTROLS(CONTROL_SETTING);

	end;
    end if;

    -- Adjust the view point
    --
    VIEW_DIRECTION_MANAGER.SWIVEL(VIEW_MANAGER.VIEW_DIRECTION,
	CONTROL_SETTING.VD_CONTROL,
	MAIN_SIMULATION.ELAPSED_SINCE_LAST_ITERATION);

end;
