--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    CONTROLS, INTEGER_MIN, MAIN_SIMULATION, MOVE_UTILITIES,
    WORLD_PHYSICS, SCALAR_PHYSICS, ANGULAR_PHYSICS, TRIG, SCALE_TYPE_TRIG,
    OBJECT_VELOCITY_TO_WORLD_VELOCITY,
    AUTOMATIC_MAGIC_CARPET, IS_DEMO_PKG;

pragma ELABORATE(
    CONTROLS, INTEGER_MIN, MAIN_SIMULATION, MOVE_UTILITIES,
    WORLD_PHYSICS, SCALAR_PHYSICS, ANGULAR_PHYSICS, TRIG, SCALE_TYPE_TRIG,
    OBJECT_VELOCITY_TO_WORLD_VELOCITY,
    AUTOMATIC_MAGIC_CARPET, IS_DEMO_PKG);

separate(MOVE)
    package body MAGIC_CARPET is
	use SCALAR_PHYSICS, ANGULAR_PHYSICS, WORLD_PHYSICS,
	    TRIG, SCALE_TYPE_TRIG;

	subtype SECONDS is SCALAR_PHYSICS.SECONDS;

	MAX_ANGULAR_SPEED : constant RADIANS_PER_SECOND
	    := RADIANS(RADIANS_PER_RIGHT_ANGLE)/SECONDS(0.25);

	MAX_HORIZONTAL_SPEED : constant METRES_PER_SECOND
	    := 6400.0;
	    
	MAX_VERTICAL_SPEED : constant METRES_PER_SECOND
	    := 1500.0;

	procedure AUTOMATIC (O : in out OBJECTS.OBJECT_TYPE) is
	begin
	    O.DELETE_PENDING := TRUE;
	end;

	procedure CONTROLLED(O : in out OBJECTS.OBJECT_TYPE;
			     CS : CONTROL_SETTING_TYPE) is

	    TIME_DELTA : constant SECONDS
		:= MAIN_SIMULATION.ELAPSED_SINCE_LAST_ITERATION;

	    LEFT_RIGHT : constant SCALE_TYPE
		:=  (SCALE_TYPE(CS.STICK_LEFT_RIGHT)/
		     SCALE_TYPE(CONTROLS.STICK_LEFT_RIGHT_TYPE'last));

	    ANGULAR_SPEED : constant RADIANS_PER_SECOND
		:= (-MAX_ANGULAR_SPEED) *
		    SCALE_TYPE(LEFT_RIGHT*(abs LEFT_RIGHT));

	    SIDEWAYS_SPEED : constant METRES_PER_SECOND
		:= MAX_HORIZONTAL_SPEED *
		        ((SCALE_TYPE(CS.RUDDER)/
		          SCALE_TYPE(CONTROLS.RUDDER_TYPE'last))**3);

	    THROTTLE_VALUE  : constant INTEGER
			    :=	INTEGER(CS.THROTTLE) -
				INTEGER(CONTROLS.THROTTLE_TYPE'last)/2;

	    THROTTLE_MAG    : constant INTEGER
			    := INTEGER_MIN(20, abs THROTTLE_VALUE);

	    THROTTLE_SIGN   : constant INTEGER
			    := BOOLEAN'pos(THROTTLE_VALUE >= 0)*2-1;

	    FORWARD_SPEED : constant METRES_PER_SECOND
		:=  12.5*SCALE_TYPE(THROTTLE_SIGN*(2**THROTTLE_MAG-1));

	    VERTICAL_SPEED : constant METRES_PER_SECOND
		:=  (-MAX_VERTICAL_SPEED) *
		        ((SCALE_TYPE(CS.STICK_FORWARD_BACK)/
		          SCALE_TYPE(CONTROLS.STICK_FORWARD_BACK_TYPE'last))**3);

	begin
	    -- Hack to fly an automatic magic carpet
	    --
	    if CS.AFTERBURNER_ON
	    or IS_DEMO_PKG.IS_DEMO
	    then
		declare
		    use OBJECTS;
		    LOCATION_DELTA : POSITION;
		begin
		    AUTOMATIC_MAGIC_CARPET.MOVE(O, CS);
		    begin
			LOCATION_DELTA.I := METRES(O.LOCATION.I-O.OLD_LOCATION.I);
			LOCATION_DELTA.J := METRES(O.LOCATION.J-O.OLD_LOCATION.J);
			LOCATION_DELTA.K := METRES(O.LOCATION.K-O.OLD_LOCATION.K);
			-- average over five samples to smooth out
			O.VELOCITY := O.VELOCITY*SCALE_TYPE'(0.9) +
			    (LOCATION_DELTA/TIME_DELTA)*SCALE_TYPE'(0.1);
		    exception
			when others => null;
		    end;
		    return;
		end;
	    else
		AUTOMATIC_MAGIC_CARPET.CLEAR;
	    end if;

	    -- New direction
	    --
	    declare
		ANGULAR_DELTA : constant RADIANS
			:= ANGULAR_SPEED*TIME_DELTA;
	    begin
		MOVE_UTILITIES.ROTATE_ABOUT_K(
		    SIN(ANGULAR_DELTA),
		    COS(ANGULAR_DELTA),
		    O.ORIENTATION);
	    end;

	    -- New position
	    --
	    declare
		use OBJECTS;
		MOVEMENT : WORLD_PHYSICS.POSITION;
	    begin

		OBJECT_VELOCITY_TO_WORLD_VELOCITY(
		    O.ORIENTATION,
		    (SIDEWAYS_SPEED, FORWARD_SPEED, VERTICAL_SPEED),
		    O.VELOCITY);

		MOVEMENT :=
		        O.ORIENTATION.I*
			SCALE_TYPE( SIDEWAYS_SPEED*TIME_DELTA)
		    +   O.ORIENTATION.J*
			SCALE_TYPE( FORWARD_SPEED*TIME_DELTA)
		    +   O.ORIENTATION.K*
			SCALE_TYPE( VERTICAL_SPEED*TIME_DELTA);

		MOVE_UTILITIES.ADD_MOVEMENT_TO_LOCATION(MOVEMENT, O.LOCATION);
	    end;
	end;
    end;
