--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    AEROPLANE, MAIN_SIMULATION, SCALAR_PHYSICS, IS_DEMO_PKG, LOGICAL_TO_BOOLEAN;

pragma ELABORATE(
    AEROPLANE, MAIN_SIMULATION, SCALAR_PHYSICS, IS_DEMO_PKG);

separate(MOVE)
    package body AEROPLANE is

	DELETE_AEROPLANE : constant BOOLEAN
	    := LOGICAL_TO_BOOLEAN("FCTM_DELETE_AEROPLANE", TRUE);

	procedure AUTOMATIC (O : in out OBJECTS.OBJECT_TYPE) is
	begin
	    if IS_DEMO_PKG.IS_DEMO then
		STANDARD.AEROPLANE.MOVE_CONTROLLED_BY_AUTOPILOT(O,
		    MAIN_SIMULATION.ELAPSED_SINCE_LAST_ITERATION);
	    elsif DELETE_AEROPLANE then
		O.DELETE_PENDING := TRUE;
	    end if;
	end;

	procedure CONTROLLED(O : in out OBJECTS.OBJECT_TYPE;
			     CS : in out CONTROL_SETTING_TYPE)
	is
	begin
	    STANDARD.AEROPLANE.MOVE(
		O,
		MAIN_SIMULATION.ELAPSED_SINCE_LAST_ITERATION,
		CS);
	    STANDARD.AEROPLANE.SET_INSTRUMENTS(O);
	end;

    end;
