--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    SCALAR_PHYSICS, WORLD_PHYSICS;
use
    SCALAR_PHYSICS, WORLD_PHYSICS;

pragma ELABORATE(
    SCALAR_PHYSICS, WORLD_PHYSICS);

package body MISSILE_UTILITIES is

    subtype SECONDS is SCALAR_PHYSICS.SECONDS;

    procedure SET_BASIS_FROM_J(
	O : in out OBJECTS.OBJECT_TYPE;
	STABILIZE_ON_I_NOT_K : BOOLEAN) is
    begin
	if STABILIZE_ON_I_NOT_K then
	    O.ORIENTATION.I.I :=  0.0;
	    O.ORIENTATION.I.J := -O.ORIENTATION.J.K;
	    O.ORIENTATION.I.K :=  O.ORIENTATION.J.J;
	else
	    O.ORIENTATION.I.I :=  O.ORIENTATION.J.J;
	    O.ORIENTATION.I.J := -O.ORIENTATION.J.I;
	    O.ORIENTATION.I.K :=  0.0;
	end if;

	O.ORIENTATION.K := O.ORIENTATION.J;
	CROSS(O.ORIENTATION.I, O.ORIENTATION.K);
    end;

    procedure SET_BASIS_FROM_VELOCITY(
	O : in out OBJECTS.OBJECT_TYPE;
	STABILIZE_ON_I_NOT_K : BOOLEAN) is

	V	    : constant METRES_PER_SECOND  := LENGTH(O.VELOCITY);
	INVERSE_V   : constant SECONDS := SECONDS'(1.0)/SCALE_TYPE(V);

    begin
	O.ORIENTATION.J.I :=  O.VELOCITY.I * INVERSE_V;
	O.ORIENTATION.J.J :=  O.VELOCITY.J * INVERSE_V;
	O.ORIENTATION.J.K :=  O.VELOCITY.K * INVERSE_V;
	SET_BASIS_FROM_J(O, STABILIZE_ON_I_NOT_K);
    end;

end;
