--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    LOGICAL_TO_FLOAT, SCALAR_PHYSICS, WORLD_PHYSICS, MAIN_SIMULATION;
use 
		      SCALAR_PHYSICS, WORLD_PHYSICS, MAIN_SIMULATION;

pragma ELABORATE(
    LOGICAL_TO_FLOAT, SCALAR_PHYSICS, WORLD_PHYSICS);

package body MISSILE_GUIDANCE is

    SIGNAL_AMPLIFICATION : constant SCALE_TYPE
	:= SCALE_TYPE(LOGICAL_TO_FLOAT("FCTM_MISSILE_SIGNAL_AMPLIFICATION",
					3.2E0));

    procedure GUIDE(
	MISSILE_OR_CARRIER  : in out OBJECT_TYPE;
	SIGNAL_STRENGTH     : out SIGNAL_STRENGTH_TYPE;
	TARGET		    : out ACCESS_OBJECT_TYPE) is

	MC : OBJECT_TYPE renames MISSILE_OR_CARRIER;

	ACCESS_TARGET	    : ACCESS_OBJECT_TYPE;
	BEST_TARGET	    : ACCESS_OBJECT_TYPE    := null;
	BEST_SIGNAL_STRENGTH: SIGNAL_STRENGTH_TYPE  := 0.0;

    begin

	-- for all possible targets
	--
	for I in THIS_SIMULATOR..ANOTHER_SIMULATOR loop
	    ACCESS_TARGET := MAINTAINER_TO_ACCESS_OBJECT(I);
	    while ACCESS_TARGET /= null loop
		declare
		    TARGET : OBJECT_TYPE renames ACCESS_TARGET.all;
		begin
		    exit when TARGET.CLASS not in TARGET_CLASS_SUBTYPE;
		    if MC.SEQUENCE_NUMBER /= TARGET.SEQUENCE_NUMBER then

declare
    MISSILE_TO_TARGET   : constant POSITION
	:= (METRES(TARGET.LOCATION.I-MC.LOCATION.I),
	    METRES(TARGET.LOCATION.J-MC.LOCATION.J),
	    METRES(TARGET.LOCATION.K-MC.LOCATION.K));

    DISTANCE	    : constant METRES
	:= LENGTH(MISSILE_TO_TARGET);

    J_DISTANCE	    : constant METRES
	:= "&"(MISSILE_TO_TARGET, MC.ORIENTATION.J);

begin
    -- if visible
    --
    if J_DISTANCE > DISTANCE*COS_SEARCH_ANGLE then
	declare
	    -- aspect and distance to strength
	    --
	    ASPECT_OF_TARGET : constant SCALE_TYPE
		:=  SCALE_TYPE("&"(MISSILE_TO_TARGET, TARGET.ORIENTATION.J))/
		    SCALE_TYPE(DISTANCE);

	    SIGNAL_STRENGTH  : constant SIGNAL_STRENGTH_TYPE
		:= SIGNAL_STRENGTH_TYPE(
			(SIGNAL_AMPLIFICATION*(ASPECT_OF_TARGET-0.5))/
			    (SCALE_TYPE(DISTANCE)**2)
			);
	begin
	    -- better than best-so-far?
	    --
	    if SIGNAL_STRENGTH > BEST_SIGNAL_STRENGTH then
		BEST_TARGET := ACCESS_TARGET;
		BEST_SIGNAL_STRENGTH := SIGNAL_STRENGTH;
	    end if;
	end;
    end if;
end;

		    end if;
		    ACCESS_TARGET := TARGET.NEXT;
		end;
	    end loop;   -- scanning targets, inner
	end loop;   -- scanning targets

	-- Can it even be detected?
	--
	if BEST_SIGNAL_STRENGTH < MINIMUM_DETECTABLE_SIGNAL_STRENGTH then
	    BEST_TARGET := null;
	    BEST_SIGNAL_STRENGTH := 0.0;
	end if;

	-- Downgrade if necessary to the saturation level
	--
	if MAX_SIGNAL_STRENGTH < BEST_SIGNAL_STRENGTH then
	    BEST_SIGNAL_STRENGTH := MAX_SIGNAL_STRENGTH;
	end if;

	-- Return how strong the signal is
	--
	SIGNAL_STRENGTH := BEST_SIGNAL_STRENGTH;
	TARGET		:= BEST_TARGET;

    end;

end; pragma SUPPRESS_ALL;
