--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    MISSILE_AERODYNAMICS_MOVE_CONTEXT, TEXT_IO, FLOAT_TEXT_IO;
pragma ELABORATE(
    MISSILE_AERODYNAMICS_MOVE_CONTEXT, TEXT_IO, FLOAT_TEXT_IO);

separate(MISSILE_AERODYNAMICS)
    package body VARIOUS_MISSILES is
	use MISSILE_AERODYNAMICS_MOVE_CONTEXT, TEXT_IO, FLOAT_TEXT_IO;

	function GET_NAME(I : POSITIVE) return STRING is
	begin
	    return "";
	end;

	function GET(NAME : STRING) return ACCESS_MISSILE_TYPE is

	    DENSITY : constant SCALE_TYPE := 0.5;

	    INIT_V  : constant SCALE_TYPE := 300.0;
	    INIT_M  : constant SCALE_TYPE := 85.0;

	    MAX_V   : constant SCALE_TYPE := 750.0;
	    MAX_T   : constant SCALE_TYPE := 2.0;

	    SUS_T   : constant SCALE_TYPE := 4.0;

	    GLIDE_M : constant SCALE_TYPE := 35.0;
	    GLIDE_V : constant SCALE_TYPE := 150.0;
	    GLIDE_X : constant SCALE_TYPE := 17_000.0;
	    GLIDE_T : constant SCALE_TYPE := 54.0;

	    -- derived
	    --
	    ZDM     : SCALE_TYPE;
	    SUS_F   : SCALE_TYPE;
	    MAX_F   : SCALE_TYPE;
	    CONSUMPTION : SCALE_TYPE;

	    procedure DEB_PUT(S : STRING; V : SCALE_TYPE) is
	    begin
		if DEBUGGING then
		    PUT(F, S); PUT(F, FLOAT(V)); NEW_LINE(F);
		end if;
	    end;
	begin
	    -- estimate the zero-drag-modifier
	    --
	    declare
		X   : SCALE_TYPE
		    := GLIDE_X - MAX_T*(MAX_V+INIT_V)/2.0 - SUS_T*MAX_V;
		V   : SCALE_TYPE
		    := X/GLIDE_T;
		A   : SCALE_TYPE
		    := (MAX_V - GLIDE_V)/GLIDE_T;
	    begin
		ZDM := (A*GLIDE_M)/(DENSITY*V**2);
		DEB_PUT("ZDM = ", ZDM);
	    end;

	    -- estimate the sustaining thrust
	    --
	    begin
		SUS_F := ZDM*(DENSITY*MAX_V**2);
		DEB_PUT("SUS_F = ", SUS_F);
	    end;

	    -- estimate the accelerating thrust
	    --
	    begin
		MAX_F := SUS_F + (INIT_M+GLIDE_M)/2.0 * (MAX_V-INIT_V)/MAX_T;
		DEB_PUT("MAX_F = ", MAX_F);
	    end;

	    -- estimate the fuel consumption per N thrust
	    --
	    begin
		CONSUMPTION := (INIT_M-GLIDE_M)/(MAX_T*MAX_F+SUS_T*SUS_F);
		DEB_PUT("CONSUMPTION = ", CONSUMPTION);
	    end;

	    -- fill in
	    --
	    return new MISSILE_TYPE'(
NAME				=> new STRING'(NAME),
EMPTY_MASS			=> KILOGRAMS(GLIDE_M),
FUEL_MASS			=> KILOGRAMS(INIT_M-GLIDE_M),
FUEL_MASS_FOR_SUSTAIN		=> KILOGRAMS(INIT_M-GLIDE_M-
						MAX_F*CONSUMPTION*MAX_T),
ENGINE_CONSUMPTION		=> CONSUMPTION,
ENGINE_BOOST_THRUST		=> NEWTONS(MAX_F),
ENGINE_SUSTAIN_THRUST		=> NEWTONS(SUS_F),
MAX_IK_NEWTONS_PER_DENSITY_V2	=> ((30.0 * 500.0**2)/	-- empty mass * accel**2
				    (0.5 * 750.0**2)),	-- density * vel**2
IK_ACCELERATION_DRAG_MULTIPLIER =>    0.20,
ZERO_DRAG_MULTIPLIER		=>     ZDM,
APPEARANCE_INFO 		=>       0,  -- hack
KILL_RADIUS			=>    20.0,
TIME_TO_ARM			=>     0.5
		);
	end;

    end;
