--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with LIFT_DRAG_CURVE_MANAGER, FIX_BASIS;
use  LIFT_DRAG_CURVE_MANAGER;

with TRIG, SCALAR_PHYSICS,  ANGULAR_PHYSICS, OBJECTS, STANDARD_ATMOSPHERE, WORLD_PHYSICS;
use  TRIG, SCALAR_PHYSICS,  ANGULAR_PHYSICS;

with INFO_MANAGER, UNCHECKED_DEALLOCATION;
use  INFO_MANAGER;

with LOGICAL_TO_FLOAT, LOGICAL_TO_BOOLEAN, SYSTEM_INTERFACE;

with MISSILE_UTILITIES;

pragma ELABORATE(LIFT_DRAG_CURVE_MANAGER,  FIX_BASIS, ANGULAR_PHYSICS);
pragma ELABORATE(INFO_MANAGER, UNCHECKED_DEALLOCATION);
pragma ELABORATE(LOGICAL_TO_FLOAT, LOGICAL_TO_BOOLEAN, SYSTEM_INTERFACE);
pragma ELABORATE(MISSILE_UTILITIES);

package body MISSILE_AERODYNAMICS is

    subtype SECONDS is SCALAR_PHYSICS.SECONDS;

    type MISSILE_NAME_TYPE is access STRING;

    type MISSILE_TYPE is
	record
	    NAME			    : MISSILE_NAME_TYPE;

	    -- Mass issues
	    --
	    EMPTY_MASS			    : KILOGRAMS;
	    FUEL_MASS			    : KILOGRAMS;
	    FUEL_MASS_FOR_SUSTAIN	    : KILOGRAMS;

	    -- Engine issues
	    --
	    ENGINE_CONSUMPTION		    : SCALE_TYPE;
					    --KILOGRAMS_PER_SECOND_PER_NEWTON;

	    ENGINE_BOOST_THRUST		    : NEWTONS;
	    ENGINE_SUSTAIN_THRUST	    : NEWTONS;

	    -- Manoeuvre
	    --
	    MAX_IK_NEWTONS_PER_DENSITY_V2   : SCALE_TYPE;
	    IK_ACCELERATION_DRAG_MULTIPLIER : SCALE_TYPE;

	    -- Body
	    --
		-- 0.5*S*Cd_zero_lift
		--
	    ZERO_DRAG_MULTIPLIER	    : SCALE_TYPE;

	    -- Misc.
	    --
	    APPEARANCE_INFO		    : APPEARANCE_INFO_TYPE;
	    KILL_RADIUS			    : METRES;
	    TIME_TO_ARM 		    : SECONDS;

	end record;

    type ACCESS_MISSILE_TYPE is access MISSILE_TYPE;

    type MISSILE_STATUS_TYPE is
	record
	    MISSILE			    : ACCESS_MISSILE_TYPE;
	    FUEL_MASS			    : KILOGRAMS 	    := 0.0;
	    TIME_DELTA_CARRIED_FORWARD	    : SECONDS		    := 0.0;
	    TIME_IN_FLIGHT		    : SECONDS		    := 0.0;
	    ARMED			    : BOOLEAN		    := FALSE;

	    DENSITY			    : KILOGRAMS_PER_METRE_CUBED;
	    THRUST			    : NEWTONS;

	    TARGET			    : OBJECTS.ACCESS_OBJECT_TYPE;
	    TIME_WITHOUT_TARGET 	    : SECONDS		    := 0.0;

	    TRACKING			    : BOOLEAN		    := FALSE;
	    TRACKING_TAN_I,
	    TRACKING_TAN_K		    : SCALE_TYPE;

	    STABILIZE_ON_I_NOT_K	    : BOOLEAN		    := FALSE;
	end record;


    type ACCESS_MISSILE_STATUS_TYPE is access MISSILE_STATUS_TYPE;
    procedure DEALLOCATE is new UNCHECKED_DEALLOCATION(
	MISSILE_STATUS_TYPE, ACCESS_MISSILE_STATUS_TYPE);

    MAX_SUBCLASS_INFO : constant SUBCLASS_INFO_TYPE := 255;
    SUBCLASS_INFO_TO_ACCESS_MISSILE_STATUS :
	array(1..MAX_SUBCLASS_INFO) of ACCESS_MISSILE_STATUS_TYPE;

    DEFAULT_SUBCLASS_INFO : constant SUBCLASS_INFO_TYPE := ASSIGN;

    PARTIAL_TIME_DELTA : constant SECONDS
	:= SECONDS(LOGICAL_TO_FLOAT("FCTM_MISSILE_AERODYNAMICS_STEP", 0.03));

    DEBUGGING : constant BOOLEAN
	:= LOGICAL_TO_BOOLEAN("FCTM_MISSILE_DEBUGGING", FALSE);


    function SQRT is new SYSTEM_INTERFACE.DIGITS_SQRT(METRES);
    function SQRT is new SYSTEM_INTERfACE.DIGITS_SQRT(SCALE_TYPE);


    procedure CREATED(O : in out OBJECTS.OBJECT_TYPE) is
	AMS : ACCESS_MISSILE_STATUS_TYPE := new MISSILE_STATUS_TYPE;
	MS  : MISSILE_STATUS_TYPE renames AMS.all;
    begin
	if O.SUBCLASS_INFO /= 0 then raise PROGRAM_ERROR; end if;

	O.SUBCLASS_INFO := ASSIGN;

	SUBCLASS_INFO_TO_ACCESS_MISSILE_STATUS(O.SUBCLASS_INFO) := AMS;
	MS := SUBCLASS_INFO_TO_ACCESS_MISSILE_STATUS(DEFAULT_SUBCLASS_INFO).all;
	MS.STABILIZE_ON_I_NOT_K := abs(O.VELOCITY.K) > 0.7;

	--	Do from launch orientation, not velocity, so the guidance input
	--	shows the lead selected by the launcher, and causes the missile
	--	to try and keep THAT amount of lead.  This corresponds to the
	--	missile starting to track while still on the rail of the
	--	launcher.
	--
	MISSILE_UTILITIES.SET_BASIS_FROM_J(O, MS.STABILIZE_ON_I_NOT_K);

    end;


    procedure ABOUT_TO_DELETE(O : in out OBJECTS.OBJECT_TYPE) is
    begin
	DEALLOCATE(SUBCLASS_INFO_TO_ACCESS_MISSILE_STATUS(O.SUBCLASS_INFO));	
	DEASSIGN(O.SUBCLASS_INFO);
	O.SUBCLASS_INFO := 0;
    end;


    procedure MOVE_DELTA(
		    TIME_DELTA		    : SECONDS;
		    O			    : in out OBJECTS.OBJECT_TYPE;
		    MISSILE_STATUS	    : in out MISSILE_STATUS_TYPE
		    ) is separate;


    procedure MOVE( O			    : in out OBJECTS.OBJECT_TYPE;
		    ELAPSED_SINCE_LAST_MOVE : SCALAR_PHYSICS.SECONDS
		    ) is separate;


    package VARIOUS_MISSILES is
	function GET_NAME(I : POSITIVE) return STRING;
	function GET(NAME : STRING) return ACCESS_MISSILE_TYPE;
    end;

    package body VARIOUS_MISSILES is separate;


begin
    SUBCLASS_INFO_TO_ACCESS_MISSILE_STATUS(DEFAULT_SUBCLASS_INFO) :=
	new MISSILE_STATUS_TYPE;

    declare
	D : MISSILE_STATUS_TYPE renames
	    SUBCLASS_INFO_TO_ACCESS_MISSILE_STATUS(
		DEFAULT_SUBCLASS_INFO).all;
    begin
	D.MISSILE := VARIOUS_MISSILES.GET("Sidewinder (Vietnam)");
	D.FUEL_MASS := D.MISSILE.FUEL_MASS;
    end;
end;
