--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with MISSILE_AERODYNAMICS;

separate(MISSILE)
    procedure CREATED(
	O		: in out OBJECTS.OBJECT_TYPE)
    is
	use WORLD_PHYSICS;

	LEAD : constant SCALE_TYPE
	    := 10.0 +
		SCALE_TYPE(MISSILE_RADIUS) +
		SCALE_TYPE(LENGTH(O.VELOCITY))*SCALE_TYPE'(0.2);

	START_LOCATION	: OBJECTS.OBJECT_LOCATION renames O.LOCATION;
	
    begin
	-- Start it some distance ahead of the firing plane...,
	-- so that it won't hit the firing plane!
	--
	START_LOCATION.I := START_LOCATION.I + OBJECT_LOCATION_COORDINATE(
						O.ORIENTATION.J.I*LEAD);
	START_LOCATION.J := START_LOCATION.J + OBJECT_LOCATION_COORDINATE(
						O.ORIENTATION.J.J*LEAD);
	START_LOCATION.K := START_LOCATION.K + OBJECT_LOCATION_COORDINATE(
						O.ORIENTATION.J.K*LEAD);

	O.OLD_LOCATION := START_LOCATION;
	O.VELOCITY     := O.VELOCITY + (O.ORIENTATION.J/SCALAR_PHYSICS.SECONDS'(0.5));

	O.APPEARANCE_INFO := MISSILE_APPEARANCE_INFO;

	O.RADIUS := MISSILE_RADIUS;

	O.EXTRA_RADII(1).RADIUS := MISSILE_RADIUS;
	O.EXTRA_RADII(1).ORIGIN := (0.0, 0.0, 0.0);

	MISSILE_AERODYNAMICS.CREATED(O);

    end;
