--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    SCALAR_PHYSICS, APPEARANCE_MANAGER, INFO_MANAGER, LOGICAL_TO_FLOAT,
    MISSILE_UTILITIES, MISSILE_AERODYNAMICS;

pragma ELABORATE(
    SCALAR_PHYSICS, APPEARANCE_MANAGER, INFO_MANAGER, LOGICAL_TO_FLOAT,
    MISSILE_UTILITIES);

package body MISSILE is
    use SCALAR_PHYSICS, OBJECTS, APPEARANCE_MANAGER;

    MISSILE_APPEARANCE_INFO
	: constant INFO_MANAGER.APPEARANCE_INFO_TYPE
        := APPEARANCE_MANAGER.CREATE(
		APPEARANCE_MANAGER.PREALLOCATED_APPEARANCES_PKG.MISSILES);

    MISSILE_APPEARANCE
	: constant APPEARANCE_MANAGER.ACCESS_APPEARANCE_TYPE
        := APPEARANCE_MANAGER.TO_ACCESS_APPEARANCE_TYPE(
		MISSILE_APPEARANCE_INFO);

    MISSILE_RADIUS : constant METRES := 0.2;	-- Small, until armed!


    procedure CREATED(
	O		: in out OBJECTS.OBJECT_TYPE) is separate;


    procedure ABOUT_TO_DELETE(
	OBJECT		: in out OBJECTS.OBJECT_TYPE) is
    begin
	MISSILE_AERODYNAMICS.ABOUT_TO_DELETE(OBJECT);
    end;


begin
    ADD_POINTS(MISSILE_APPEARANCE,
	VECTOR_OF_POSITION'(
	(  0.1, -1.0, 0.0),
	(  0.0,  1.0, 0.0),
	( -0.1, -1.0, 0.0))
	);
    FINISH_CREATING_SUBPICTURES(MISSILE_APPEARANCE);
end;
