--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    INFO_MANAGER,   WORLD_PHYSICS,  OBJECTS,
    COMPRESSED_ORIENTATION_MANAGER, ETHERNET;
use
    INFO_MANAGER,   WORLD_PHYSICS,  OBJECTS;

package MESSAGE_MANAGER is

    type REASON_TYPE is (
	NONE,
	OBJECT_HERE,
	CREATE_MISSILE,
	HIT_BY_BULLETS,
	HIT_BY_OBJECT,
	RADIO_TEXT,
	TIME_TO_QUIT
	);

    MAX_RADIO_TEXT_LENGTH : constant INTEGER
	-- Adjusted to cause the allocation of the MESSAGE_ITEM_TYPE to exactly
	-- fulfill its alignment requirements, so that the following vector
	-- is densely packed.
	--
	:= 30;

    type MESSAGE_ITEM_TYPE(REASON : REASON_TYPE := NONE) is
	record
	    case REASON is

		when NONE =>
		    null;

		when OBJECT_HERE|CREATE_MISSILE =>
		    --
		    -- subset of the OBJECT_TYPE information
		    --
		    SEQUENCE_NUMBER : POSITIVE;
		    OBJECT_INFO     : OBJECT_INFO_TYPE; -- 0 when CREATE_MISSILE
		    CLASS	    : CLASS_TYPE;
		    LOCATION	    : OBJECT_LOCATION;
		    ORIENTATION     : COMPRESSED_ORIENTATION_MANAGER.
					COMPRESSED_ORIENTATION_TYPE;
		    APPEARANCE_INFO : APPEARANCE_INFO_TYPE;
		    CLASS_INFO	    : CLASS_INFO_TYPE;
		    SUBCLASS	    : SUBCLASS_TYPE;
		    
		when HIT_BY_BULLETS|HIT_BY_OBJECT =>
		    --
		    -- doesn't say what object does the hitting, it could be
		    -- a missile, bullets, plane, etc.
		    --
		    HIT_SEQUENCE_NUMBER : POSITIVE;
		    HIT_OBJECT_INFO : OBJECT_INFO_TYPE;
		    KILLED	    : BOOLEAN;

		when RADIO_TEXT =>
		    --
		    -- some text, make short enough to not make this
		    -- by far the longest variant.
		    --
		    LENGTH	    : NATURAL range 0..MAX_RADIO_TEXT_LENGTH;
		    TEXT	    : STRING(1..MAX_RADIO_TEXT_LENGTH);

		when TIME_TO_QUIT =>
		    null;

	    end case;
	end record;
	for MESSAGE_ITEM_TYPE use record
	    --
	    -- pack tightly as possible with nice alignment properties
	    -- and so that the result is a multiple of the alignment requirement
	    --
	    REASON		at  0 range 0..2;

	    CLASS		at  0 range 3..7;
	    APPEARANCE_INFO	at  1 range 0..7;
	    CLASS_INFO		at  2 range 0..7;
	    SUBCLASS		at  3 range 0..7;
	    LOCATION		at  4 range 0..95;
	    SEQUENCE_NUMBER	at 16 range 0..31;
	    ORIENTATION 	at 20 range 0..63;
	    OBJECT_INFO 	at 28 range 0..7;

	    KILLED		at  1 range 0..7;
	    HIT_OBJECT_INFO	at  2 range 0..7;
	    HIT_SEQUENCE_NUMBER at  4 range 0..31;

	    LENGTH		at  1 range 0..7;
	    TEXT		at  2 range 0..MAX_RADIO_TEXT_LENGTH*8-1;

	end record;
	pragma PACK(MESSAGE_ITEM_TYPE);

    type VECTOR_OF_MESSAGE_ITEM_TYPE is
	array(POSITIVE range <>) of MESSAGE_ITEM_TYPE;

    -- This is what is actual sent around...
    --
    subtype NUMBER_OF_ITEMS_RANGE is
	NATURAL range
	    0.. (ETHERNET.MAX_MESSAGE_TYPE_SIZE-64)/(MESSAGE_ITEM_TYPE'size);

    type MESSAGE_TYPE(NUMBER_OF_ITEMS : NUMBER_OF_ITEMS_RANGE := 0) is
	record
	    TRANSMIT_TIME   : SECONDS;
	    ITEMS	    : VECTOR_OF_MESSAGE_ITEM_TYPE(1..NUMBER_OF_ITEMS);
	end record;

private
    MESSAGE_TYPE_SIZE : INTEGER := MESSAGE_TYPE'size;
    MAX_MESSAGE_SIZE  : INTEGER := ETHERNET.MAX_MESSAGE_TYPE_SIZE;

    CHECK_NUMBER_OF_ITEMS_RANGE
	: constant BOOLEAN range TRUE..TRUE
	:= MESSAGE_TYPE'size <= ETHERNET.MAX_MESSAGE_TYPE_SIZE;

end;
