--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


package MENU_MANAGER is

    type MENU_TYPE is private;

    procedure CREATE(
	TITLE : in STRING := "";
	MENU : in out MENU_TYPE);

    procedure APPEND(
	ITEM : in STRING;
	KEY  : in INTEGER;
	MENU : in out MENU_TYPE);

    procedure DELETE(
	MENU : in out MENU_TYPE);

    function TITLE(
	MENU : in MENU_TYPE)
	return STRING;

    function LENGTH(
	MENU : in MENU_TYPE)
	return NATURAL;

    function WIDTH(
	MENU : in MENU_TYPE)
	return NATURAL;

    generic
	with procedure PROCESS(
	    POSITION	: in POSITIVE;
	    ITEM	: in STRING;
	    KEY 	: in INTEGER;
	    CONTINUE	: in out BOOLEAN);
    procedure PROCESS_ALL(
	MENU : in MENU_TYPE);

    generic
	with procedure PROCESS(
	    ITEM	: in STRING;
	    KEY 	: in INTEGER);
    procedure PROCESS_ONE_BY_POSITION(
	POSITION : in POSITIVE;
	MENU	 : in MENU_TYPE);

    generic
	with procedure PROCESS(
	    ITEM	: in STRING;
	    KEY 	: in INTEGER);
    procedure PROCESS_ONE_BY_ITEM(
	ITEM	: in STRING;
	MENU	: in MENU_TYPE);

private
    type MENU_INTERNALS_TYPE;
    type MENU_TYPE is access MENU_INTERNALS_TYPE;

end;
