--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    CHARACTER_UTILITIES, INTEGER_MAX, UNCHECKED_DEALLOCATION;

pragma ELABORATE(
    CHARACTER_UTILITIES, INTEGER_MAX, UNCHECKED_DEALLOCATION);

package body MENU_MANAGER is

    type ACCESS_STRING is access STRING;

    type MENU_ITEM_TYPE;
    type ACCESS_MENU_ITEM_TYPE is access MENU_ITEM_TYPE;
    type MENU_ITEM_TYPE is
	record
	    ITEM    : ACCESS_STRING;
	    KEY     : INTEGER;
	    NEXT    : ACCESS_MENU_ITEM_TYPE;
	end record;

    type MENU_INTERNALS_TYPE is
	record
	    TITLE   : ACCESS_STRING;
	    LENGTH  : NATURAL;
	    WIDTH   : NATURAL;
	    FIRST,
	    LAST    : ACCESS_MENU_ITEM_TYPE;
	end record;


    procedure DEALLOCATE is
	new UNCHECKED_DEALLOCATION(STRING, ACCESS_STRING);

    procedure DEALLOCATE is
	new UNCHECKED_DEALLOCATION(MENU_ITEM_TYPE, ACCESS_MENU_ITEM_TYPE);

    procedure DEALLOCATE is
	new UNCHECKED_DEALLOCATION(MENU_INTERNALS_TYPE, MENU_TYPE);


    procedure CREATE(
	TITLE : in STRING := "";
	MENU  : in out MENU_TYPE)
    is
    begin
	if MENU /= null then raise CONSTRAINT_ERROR; end if;
	MENU := new MENU_INTERNALS_TYPE'(
	    TITLE  => new STRING'(TITLE),
	    LENGTH => 0,
	    WIDTH  => 0,
	    FIRST|LAST  => null);
    end;

    procedure APPEND(
	ITEM : in STRING;
	KEY  : in INTEGER;
	MENU : in out MENU_TYPE)
    is
	ME  : constant ACCESS_MENU_ITEM_TYPE
	    := new MENU_ITEM_TYPE'(
		    ITEM => new STRING'(ITEM),
		    KEY  => KEY,
		    NEXT => null);
    begin
	MENU.LENGTH := MENU.LENGTH + 1;
	MENU.WIDTH := INTEGER_MAX(MENU.WIDTH, ITEM'length);
	if MENU.FIRST = null then
	    MENU.FIRST := ME;
	else
	    MENU.LAST.NEXT := ME;
	end if;
	MENU.LAST := ME;
    end;

    procedure DELETE(
	MENU : in out MENU_TYPE) is
	ME, NEXT : ACCESS_MENU_ITEM_TYPE;
    begin
	ME := MENU.FIRST;
	while ME /= null loop
	    NEXT := ME.NEXT;
	    DEALLOCATE(ME.ITEM);
	    DEALLOCATE(ME);
	    ME := NEXT;
	end loop;
	DEALLOCATE(MENU.TITLE);
	DEALLOCATE(MENU);
    end;

    function TITLE(
	MENU : in MENU_TYPE)
	return STRING is
    begin
	return MENU.TITLE.all;
    end;

    function LENGTH(
	MENU : in MENU_TYPE)
	return NATURAL is
    begin
	return MENU.LENGTH;
    end;

    function WIDTH(
	MENU : in MENU_TYPE)
	return NATURAL is
    begin
	return MENU.WIDTH;
    end;

    procedure PROCESS_ALL(
	MENU : in MENU_TYPE) is

	ME	 : ACCESS_MENU_ITEM_TYPE := MENU.FIRST;
	POSITION : POSITIVE := 1;
	CONTINUE : BOOLEAN  := TRUE;
    begin
	while ME /= null loop
	    PROCESS(POSITION, ME.ITEM.all, ME.KEY, CONTINUE);
	    exit when not CONTINUE;
	    POSITION := POSITION + 1;
	    ME := ME.NEXT;
	end loop;
    end;

    procedure PROCESS_ONE_BY_POSITION(
	POSITION : in POSITIVE;
	MENU	 : in MENU_TYPE)
    is
	ME	 : ACCESS_MENU_ITEM_TYPE := MENU.FIRST;
	COUNT	 : POSITIVE := 1;
    begin
	while ME /= null loop
	    if COUNT = POSITION then
		PROCESS(ME.ITEM.all, ME.KEY);
		exit;
	    end if;
	    COUNT := COUNT + 1;
	    ME := ME.NEXT;
	end loop;
    end;

    procedure PROCESS_ONE_BY_ITEM(
	ITEM	: in STRING;
	MENU	: in MENU_TYPE)
    is
	ME	 : ACCESS_MENU_ITEM_TYPE := MENU.FIRST;
    begin
	while ME /= null loop
	    if CHARACTER_UTILITIES.SOMEWHAT_EQUAL(ME.ITEM.all, ITEM) then
		PROCESS(ME.ITEM.all, ME.KEY);
		exit;
	    end if;
	    ME := ME.NEXT;
	end loop;
    end;

end;
