--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with 
    CONTROLS, CONTROLLED_OBJECT,
    INTERACTIVE_CONTROLS, INIT_CONTROLS, INSTRUMENTS, INSTRUMENT_PANEL,
    VIEW_MANAGER, VIEW_DIRECTION_MANAGER;

pragma ELABORATE(
    CONTROLS, CONTROLLED_OBJECT,
    INTERACTIVE_CONTROLS, INIT_CONTROLS, INSTRUMENTS, INSTRUMENT_PANEL,
    VIEW_MANAGER, VIEW_DIRECTION_MANAGER);

separate(MAIN_SIMULATION)
    task body OBJECT_SYNC is

	ELAPSED_SINCE_LAST_ITERATION_DURATION,
	ELAPSED_SINCE_LAST_TRANSMIT_TO_PARTNERS,
	ELAPSED_SINCE_LAST_TRANSMIT_TO_FLIGHT_RECORDER,
	ELAPSED_SINCE_LAST_ACCEPT,
	TIME_TO_DELAY,
	TIME_TO_RESTART_DISPLAY : DURATION := 0.0;

	MAX_ELAPSED_SINCE_LAST_ACCEPT : constant DURATION := 1.0;

	FRAMES_COUNT  : NATURAL;

	CPU_TIME_OF_LAST_FRAMES_COUNT,
	CPU_TIME_OF_THIS_FRAMES_COUNT : DURATION;

	TIME_OF_LAST_FRAMES_COUNT : TIME;

	type PILOT_STATE_TYPE is (OK, LOOSING_VISION, BLACKED_OUT);
	PILOT_STATE : PILOT_STATE_TYPE := OK;


	package FILTER_RECORDING is
	    TO_PARTNERS 	: BOOLEAN;
	    TO_FLIGHT_RECORDER  : BOOLEAN;

	    procedure DECIDE_WHAT_TO_DO;
	end;

	package body FILTER_RECORDING is
	    procedure DECIDE_TO_DO(
		DO_IT   : out BOOLEAN;
		ELAPSED : in out DURATION;
		MINIMUM : in DURATION) is
	    begin
		ELAPSED := ELAPSED + ELAPSED_SINCE_LAST_ITERATION_DURATION;
		DO_IT := (ELAPSED > MINIMUM);
	    end;

	    procedure DECIDE_WHAT_TO_DO is
	    begin
		DECIDE_TO_DO(TO_PARTNERS,
		    ELAPSED_SINCE_LAST_TRANSMIT_TO_PARTNERS,
		    MINIMUM_DELAY_BETWEEN_TRANSMIT_TO_PARTNERS);

		DECIDE_TO_DO(TO_FLIGHT_RECORDER,
		    ELAPSED_SINCE_LAST_TRANSMIT_TO_FLIGHT_RECORDER,
		    MINIMUM_DELAY_BETWEEN_TRANSMIT_TO_FLIGHT_RECORDER);
	    end;
	end;


	package MULTIPLAYER_SUPPORT is
	    procedure RECEIVE_UPDATES;
	    procedure TRANSMIT_UPDATES(
		THIS_SIMULATORS_OBJECTS : OBJECTS.ACCESS_OBJECT_TYPE);
	    procedure TRANSMIT_DELETE_PENDING(OBJECT : OBJECTS.ACCESS_OBJECT_TYPE);
	end;

	package body MULTIPLAYER_SUPPORT is separate;


	procedure COLLISION_CHECK is separate;


	procedure UPDATE_TIME is
	begin
	    TIME_OF_THIS_ITERATION := CLOCK;
	    ELAPSED_SINCE_LAST_ITERATION_DURATION :=
		TIME_OF_THIS_ITERATION-TIME_OF_LAST_ITERATION;
	    ELAPSED_SINCE_LAST_ITERATION :=
		SCALAR_PHYSICS.SECONDS(ELAPSED_SINCE_LAST_ITERATION_DURATION);
	end;


    begin
	accept START(STATIONARY_OBJECTS : OBJECTS.ACCESS_OBJECT_TYPE) do
	    declare
		LAST : OBJECTS.ACCESS_OBJECT_TYPE := STATIONARY_OBJECTS;
	    begin
		MAINTAINER_TO_ACCESS_OBJECT(NONE_NEEDED) := STATIONARY_OBJECTS;
		while LAST /= null and then LAST.NEXT /= null loop
		    LAST := LAST.NEXT;
		end loop;
		MAINTAINER_TO_ACCESS_OBJECT_TAIL(NONE_NEEDED) := LAST;
	    end;
	end;

	TIME_OF_LAST_ITERATION		:= CLOCK;
	FRAMES_COUNT			:= 0;
	CPU_TIME_OF_LAST_FRAMES_COUNT	:= GET_CPU_TIME;
	TIME_OF_LAST_FRAMES_COUNT	:= TIME_OF_LAST_ITERATION;

	while not CONTROLS.EXIT_PRESSED loop

	    UPDATE_TIME;

	    TIME_TO_DELAY :=
		MINIMUM_DELAY_BETWEEN_ITERATIONS -
		ELAPSED_SINCE_LAST_ITERATION_DURATION;

	    ELAPSED_SINCE_LAST_ACCEPT :=
		ELAPSED_SINCE_LAST_ACCEPT +
		ELAPSED_SINCE_LAST_ITERATION_DURATION;

	    if ELAPSED_SINCE_LAST_ACCEPT > MAX_ELAPSED_SINCE_LAST_ACCEPT
	    or TIME_TO_DELAY > 0.0
	    then
		if TIME_TO_DELAY < 0.0 then -- Avoid MIPS RTL bug
		    TIME_TO_DELAY := 0.0;
		end if;

		ELAPSED_SINCE_LAST_ACCEPT := 0.0;

		select
		    accept ADD_OBJECT(
			    CLASS	: OBJECTS.CLASS_TYPE;
			    SUBCLASS	: INFO_MANAGER.SUBCLASS_TYPE;
			    LOCATION	: OBJECTS.OBJECT_LOCATION;
			    ORIENTATION : WORLD_PHYSICS.POSITION_BASIS;
			    VELOCITY	: WORLD_PHYSICS.VELOCITY;
			    MAINTAINER	: OBJECTS.MAINTAINER_TYPE;
			    CONTROLLED	: BOOLEAN := FALSE) do

			declare
			    A : OBJECTS.ACCESS_OBJECT_TYPE :=
				OBJECTS.CREATE(
				    MAINTAINER,
				    CLASS,
				    SUBCLASS,
				    LOCATION, ORIENTATION, VELOCITY);
			begin
			    
			    ADD_ONE_OBJECT(A);

			    if CONTROLLED then
				CONTROLLED_OBJECT.OBJECT_TO_BE_CONTROLLED := A;

				VIEW_MANAGER.OBJECT_VIEWED_FROM := A;
				VIEW_MANAGER.VIEW_DIRECTION :=
				    VIEW_DIRECTION_MANAGER.DEFAULT_VIEW_DIRECTION;

				INTERACTIVE_CONTROLS.SET_CONTROLS(
				    JAMMED => FALSE);

				-- wake up when changes craft
				--
				INTERACTIVE_CONTROLS.SET_CONTROLS(
				    INIT_CONTROLS.GET_INIT_CONTROL_SETTING(A.all));
				PILOT_STATE := OK;
				TIME_TO_RESTART_DISPLAY := 0.0;

			    end if;
			end;
		    end;

		or
		    accept REMOVE_OBJECT (OBJECT : OBJECTS.ACCESS_OBJECT_TYPE) do
			REMOVE_ONE_OBJECT(OBJECT);
		    end;

		or
		    delay TIME_TO_DELAY;

		    if TIME_TO_DELAY > 0.0 then
			UPDATE_TIME;
		    end if;

		end select;
	    end if;

	    -- Decide what filtering to do
	    --
	    FILTER_RECORDING.DECIDE_WHAT_TO_DO;

	    -- Move everything
	    --
	    MULTIPLAYER_SUPPORT.RECEIVE_UPDATES;

	    MOVE_THIS_SIMULATORS_OBJECTS(
		MAINTAINER_TO_ACCESS_OBJECT(THIS_SIMULATOR));

	    COLLISION_CHECK;

	    -- Delete all DELETE_PENDING objects
	    --
	    if VIEW_MANAGER.OBJECT_VIEWED_FROM /= null
	    and then VIEW_MANAGER.OBJECT_VIEWED_FROM.DELETE_PENDING then
		VIEW_MANAGER.OBJECT_VIEWED_FROM := null;
		VIEW_MANAGER.UPDATE_VIEWPOINT;
	    end if;
		
	    if CONTROLLED_OBJECT.OBJECT_TO_BE_CONTROLLED /= null
	    and then CONTROLLED_OBJECT.OBJECT_TO_BE_CONTROLLED.DELETE_PENDING then
		CONTROLLED_OBJECT.OBJECT_TO_BE_CONTROLLED := null;
		REQUESTED_TO_SELECT_NEW_CONTROLLED_OBJECT := TRUE;
	    end if;
		
	    declare
		use OBJECTS;
		AO, DELETE_NEXT : ACCESS_OBJECT_TYPE;
	    begin
		AO := DELETE_PENDING_LIST;
		DELETE_PENDING_LIST := null;
		while AO /= null loop
		    DELETE_NEXT := AO.DELETE_NEXT;
		    REMOVE_ONE_OBJECT(AO);
		    OBJECTS.DELETE(AO);
		    AO := DELETE_NEXT;
		end loop;
	    end;

	    -- Transmit where everything is
	    --
	    MULTIPLAYER_SUPPORT.TRANSMIT_UPDATES(
		MAINTAINER_TO_ACCESS_OBJECT(THIS_SIMULATOR));

	    -- Adjust the ELAPSED_SINCE* numbers
	    --
	    if FILTER_RECORDING.TO_PARTNERS then
		ELAPSED_SINCE_LAST_TRANSMIT_TO_PARTNERS := 0.0;
	    end if;

	    if FILTER_RECORDING.TO_FLIGHT_RECORDER then
		ELAPSED_SINCE_LAST_TRANSMIT_TO_FLIGHT_RECORDER := 0.0;
	    end if;

	    -- Display generation and pilot state.
	    --
	    declare
		NEW_PILOT_STATE : PILOT_STATE_TYPE := PILOT_STATE;
		LEAVE_AS_BLANK  : BOOLEAN := (TIME_TO_RESTART_DISPLAY > 0.0);
	    begin

		INSTRUMENT_PANEL.UPDATE;

		GENERATE_NEXT_VIEW.DRAW_NEXT_VIEW(
		    MAINTAINER_TO_ACCESS_OBJECT, LEAVE_AS_BLANK);

		FRAMES_COUNT := FRAMES_COUNT + 1;

		if CONTROLLED_OBJECT.OBJECT_TO_BE_CONTROLLED = null
		or else CONTROLLED_OBJECT.OBJECT_TO_BE_CONTROLLED.CLASS /=
		    OBJECTS.AEROPLANE
		then
		    -- wake up if changes craft
		    --
		    NEW_PILOT_STATE := OK;
		    TIME_TO_RESTART_DISPLAY := 0.0;

		else
		    TIME_TO_RESTART_DISPLAY :=
			TIME_TO_RESTART_DISPLAY -
			ELAPSED_SINCE_LAST_ITERATION_DURATION;

		    declare
			use INSTRUMENTS;
			ACCEL   : constant VALUE_TYPE
				:= INSTRUMENTS.GET(INSTRUMENTS.ACCEL);
		    begin
			if ACCEL > 9.0 then
			    -- Black pilot out for 30 seconds starting now!
			    --
			    TIME_TO_RESTART_DISPLAY := 30.0;
			    NEW_PILOT_STATE := BLACKED_OUT;

			elsif PILOT_STATE = BLACKED_OUT then
			    -- Wake him after the 30 seconds
			    --
			    if TIME_TO_RESTART_DISPLAY <= 0.0 then
				NEW_PILOT_STATE := OK;
			    end if;

			elsif ACCEL < 7.0 then
			    -- Gentle turns
			    --
			    TIME_TO_RESTART_DISPLAY := 0.0;
			    NEW_PILOT_STATE := OK;

			elsif PILOT_STATE = LOOSING_VISION
			and LEAVE_AS_BLANK
			then
			    -- partial blink done
			    --
			    null;

			else
			    -- set up for the next blink
			    --
			    if ACCEL < 8.0 then
				TIME_TO_RESTART_DISPLAY := 0.05;
			    else
				TIME_TO_RESTART_DISPLAY := 0.15;
			    end if;

			    NEW_PILOT_STATE := LOOSING_VISION;
			end if;
		    end;
		end if;

		if NEW_PILOT_STATE /= PILOT_STATE then
		    INTERACTIVE_CONTROLS.SET_CONTROLS(
			NEW_PILOT_STATE = BLACKED_OUT);
		    PILOT_STATE := NEW_PILOT_STATE;
		end if;

	    end;    -- decide new pilot state

	    TIME_OF_LAST_ITERATION := TIME_OF_THIS_ITERATION;

	    if SHOW_TIMING_INFO
	    and then TIME_OF_THIS_ITERATION-TIME_OF_LAST_FRAMES_COUNT > 10.0
	    then
		CPU_TIME_OF_THIS_FRAMES_COUNT := GET_CPU_TIME;
		TEXT_IO.PUT(INTEGER'image(FRAMES_COUNT));
		TEXT_IO.PUT(
		    INTEGER'image(
			INTEGER(10.0*
			    FLOAT(CPU_TIME_OF_LAST_FRAMES_COUNT-
				  CPU_TIME_OF_THIS_FRAMES_COUNT))));
		TEXT_IO.NEW_LINE;
		FRAMES_COUNT := 0;
		CPU_TIME_OF_LAST_FRAMES_COUNT := CPU_TIME_OF_THIS_FRAMES_COUNT;
		TIME_OF_LAST_FRAMES_COUNT := TIME_OF_THIS_ITERATION;
	    end if;

	    if	REQUESTED_TO_SELECT_NEW_CONTROLLED_OBJECT then
		REQUESTED_TO_SELECT_NEW_CONTROLLED_OBJECT := FALSE;
		select
		    accept SELECT_NEW_CONTROLLED_OBJECT;
		or
		    delay 1.0;
		end select;
	    end if;

	end loop;

    end;
